var ahtFunctions = {

  // 4 variables for the original settings
  // html and remote content settings
  prefer_plaintext: false,
  html_as: 0,
  disallow_classes: 0,
  mail_inline_attachments: false,

  block: false,
  tabId: 0,

  startup: function() {
    consoleDebug("AHT: startup");

    // a block to really reset the settings only once, 
    // to prevent mixed up prefs
    ahtFunctions.block = false;
    // variable for the tab.id the reload listener is related to
    ahtFunctions.tabId = 0;
  },

  listenerToRestoreOriginalPrefs: function(tab) {
    consoleDebug("AHT: messageDisplay.onMessageDisplayed: listenerToRestoreOriginalPrefs");
    consoleDebug("AHT: messageDisplay.onMessageDisplayed: ahtFunctions.block = " + ahtFunctions.block);
    consoleDebug("AHT: messageDisplay.onMessageDisplayed: previous saved tabId = " + ahtFunctions.tabId);
    consoleDebug("AHT: messageDisplay.onMessageDisplayed: tab.id: " + tab.id);
    if ((ahtFunctions.block === true) && (ahtFunctions.tabId === tab.id)) {
      // Revert to the users default settings
      // after the message is reloaded.
      ahtFunctions.RestoreHTMLcontentPrefs();
    }
  },

  registerListener: function() {
    consoleDebug("AHT: registerListener listenerToRestoreOriginalPrefs");
    browser.messageDisplay.onMessageDisplayed.addListener(ahtFunctions.listenerToRestoreOriginalPrefs);
  },

  removeListener: function() {
    consoleDebug("AHT: removeListener listenerToRestoreOriginalPrefs");
    browser.messageDisplay.onMessageDisplayed.removeListener(ahtFunctions.listenerToRestoreOriginalPrefs);
  },

  AllowHTMLtemp: async function(tabId, infoModifiers, remoteButton) {
    consoleDebug("AHT: AllowHTMLtemp: fired");
    consoleDebug("AHT: AllowHTMLtemp: options.debug = " + options.debug);
    consoleDebug("AHT: AllowHTMLtemp: options.buttonHtmlMode = " + options.buttonHtmlMode);
    consoleDebug("AHT: AllowHTMLtemp: options.tempRemoteContent = " + options.tempRemoteContent);
    consoleDebug("AHT: AllowHTMLtemp: tabId: " + tabId);
    consoleDebug("AHT: AllowHTMLtemp: infoModifiers: " + infoModifiers);
    consoleDebug("AHT: AllowHTMLtemp: remoteButton: " + remoteButton);

    // Save users applications default settings
    // the await is absolutely important here!
    await ahtFunctions.SaveHTMLcontentPrefs(tabId);
    consoleDebug("AHT: AllowHTMLtemp: --------------------")
    consoleDebug("AHT: AllowHTMLtemp: saved values: " + ahtFunctions.prefer_plaintext + " " + ahtFunctions.html_as + " " + ahtFunctions.disallow_classes + " " + ahtFunctions.mail_inline_attachments);

    // RemoteContent popupmenu item clicked in remote content bar in a HTML message
    if (remoteButton === true) {
      consoleDebug("AHT: AllowHTMLtemp: remoteButton === true");
      ahtFunctions.ShowRemote(tabId);
    }

    // We must now differ the choosen function by modifier key (ahtKeyboardEvent).

    // Addon button clicked + both CTRL and SHIFT key
    else if((infoModifiers.includes("Ctrl") || infoModifiers.includes("Command")) && infoModifiers.includes("Shift")) {
      consoleDebug("AHT: AllowHTMLtemp: Addon button clicked + both CTRL and SHIFT key");
      ahtFunctions.ShowSanitizedHTML(tabId);
    }

    // Addon button clicked + only CTRL key
    else if((infoModifiers.includes("Ctrl") || infoModifiers.includes("Command")) && !(infoModifiers.includes("Shift"))) {
      consoleDebug("AHT: AllowHTMLtemp: Addon button clicked + only CTRL key");
      ahtFunctions.ShowRemote(tabId);
    }

    // Addon button clicked + only SHIFT key
    else if ((infoModifiers.includes("Shift")) && !((infoModifiers.includes("Ctrl") || infoModifiers.includes("Command")))) {
      consoleDebug("AHT: AllowHTMLtemp: Addon button clicked + only SHIFT key");
      ahtFunctions.ShowPlaintext(tabId);
    }

    // Addon button clicked - no key pressed
    else if (!(infoModifiers.includes("Shift") || infoModifiers.includes("Ctrl") || infoModifiers.includes("Command"))) {
      consoleDebug("AHT: AllowHTMLtemp: keyboard command pressed || button clicked + no key pressed");
      consoleDebug("AHT: AllowHTMLtemp: options.buttonHtmlMode = " + options.buttonHtmlMode);
      switch (options.buttonHtmlMode) {
        case "buttonMode_html":
          if (options.tempRemoteContent) {
            consoleDebug("AHT: html + tempRemoteContent");
            ahtFunctions.ShowRemote(tabId);
          } else {
            consoleDebug("AHT: html");
            ahtFunctions.ShowOriginalHTML(tabId);
          }
          break;
        case "buttonMode_sanitized":
          consoleDebug("AHT: sanitized");
          ahtFunctions.ShowSanitizedHTML(tabId);
          break;
        case "buttonMode_plaintext":
          consoleDebug("AHT: plaintext");
          ahtFunctions.ShowPlaintext(tabId);
          break;
        default:
          consoleDebug("AHT: default");
      }
    }
  },

  ShowPlaintext: function(tabId) {
    consoleDebug("AHT: ShowPlaintext");
    try {
      // reload message in plaintext:
      browser.AllowHtmlTempApi.msgBodyAsPlaintext(tabId, options.debug);
    } catch (e) {
      console.log("AHT: Plaintext error");
    }
  },

  ShowSanitizedHTML: function(tabId) {
    consoleDebug("AHT: ShowSanitizedHTML");
    try {
      // reload message in sanitized HTML:
      browser.AllowHtmlTempApi.msgBodySanitized(tabId, options.debug);
    } catch (e) {
      console.log("AHT: ShowSanitizedHTML error");
    }
  },

  ShowOriginalHTML: function(tabId) {
    consoleDebug("AHT: ShowOriginalHTML");
    try {
      // enable temporarily InlineAttachments if temp option is set
      if (options.tempInline === true)
        browser.LegacyPrefs.setPref("mail.inline_attachments", true);

      // reload message with original HTML:
      browser.AllowHtmlTempApi.msgBodyAllowHTML(tabId, options.debug);

    } catch (e) {
      console.log("AHT: ShowOriginalHTML error");
    }
  },

  ShowRemote: function(tabId) {
    consoleDebug("AHT: ShowRemote");
    try {
      // enable temporarily HTML
      browser.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", false);
      browser.LegacyPrefs.setPref("mailnews.display.html_as", 0);
      browser.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers",
        0);

      // enable temporarily InlineAttachments if temp option is set
      if (options.tempInline === true)
        browser.LegacyPrefs.setPref("mail.inline_attachments", true);

      // HTML is allowed now, so we can reload the message with remote content:
      browser.AllowHtmlTempApi.loadMsgWithRemoteContent(tabId, options.debug);
    } catch (e) {
      console.log("AHT: ShowRemote error");
    }
  },

  SaveHTMLcontentPrefs: async function(tabId) {
    consoleDebug("AHT: SaveHTMLcontentPrefs");

    // We need the following block to prevent from
    // starting AHT again before the return
    // to the original settings! Otherwise we would loose
    // original settings -> 'Security leak'!
    if (ahtFunctions.block === false) {
      consoleDebug("AHT: SaveHTMLcontentPrefs: ahtFunctions.block === false >>> set it to true and save the tab.id");

      ahtFunctions.block = true;
      ahtFunctions.tabId = tabId;
      ahtFunctions.registerListener();

      consoleDebug("AHT: SaveHTMLcontentPrefs: go further after ahtFunctions.registerListener()");

      ahtFunctions.prefer_plaintext = await browser.LegacyPrefs.getPref("mailnews.display.prefer_plaintext");
      ahtFunctions.html_as = await browser.LegacyPrefs.getPref("mailnews.display.html_as");
      ahtFunctions.disallow_classes = await browser.LegacyPrefs.getPref("mailnews.display.disallow_mime_handlers");
      ahtFunctions.mail_inline_attachments = await browser.LegacyPrefs.getPref("mail.inline_attachments");
    } else {
      consoleDebug("AHT: SaveHTMLcontentPrefs: ahtFunctions.block === true >>> don't save prefs AND do not register listener");
    }
  },

  RestoreHTMLcontentPrefs: async function() {
    consoleDebug("AHT: RestoreHTMLcontentPrefs");
    consoleDebug("AHT: RestoreHTMLcontentPrefs: ahtFunctions.prefer_plaintext = " + ahtFunctions.prefer_plaintext);
    consoleDebug("AHT: RestoreHTMLcontentPrefs: ahtFunctions.html_as = " + ahtFunctions.html_as);
    consoleDebug("AHT: RestoreHTMLcontentPrefs: ahtFunctions.disallow_classes = " + ahtFunctions.disallow_classes);
    consoleDebug("AHT: RestoreHTMLcontentPrefs: ahtFunctions.mail_inline_attachments = " + ahtFunctions.mail_inline_attachments);
    if (ahtFunctions.block === true) {
      await browser.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", ahtFunctions.prefer_plaintext);
      await browser.LegacyPrefs.setPref("mailnews.display.html_as", ahtFunctions.html_as);
      await browser.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers", ahtFunctions.disallow_classes);
      await browser.LegacyPrefs.setPref("mail.inline_attachments", ahtFunctions.mail_inline_attachments);

      ahtFunctions.removeListener();
      ahtFunctions.tabId = 0;
      ahtFunctions.block = false;
    }
  },

  AhtSetMsgBodyAllowHTML: function() {
    browser.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", false);
    browser.LegacyPrefs.setPref("mailnews.display.html_as", 0);
    browser.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers", 0);
  },

  AhtSetMsgBodySanitized: function() {
    browser.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", false);
    browser.LegacyPrefs.setPref("mailnews.display.html_as", 3);
    browser.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers",
      gDisallow_classes_no_html);
  },

  AhtSetMsgBodyAsPlaintext: function() {
    browser.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", true);
    browser.LegacyPrefs.setPref("mailnews.display.html_as", 1);
    browser.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers",
      gDisallow_classes_no_html);
  },

  AhtSetMsgBodyAllParts: function() {
    browser.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", false);
    browser.LegacyPrefs.setPref("mailnews.display.html_as", 4);
    browser.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers", 0);
  },

}

window.addEventListener("load", function(e) {
  ahtFunctions.startup();
}, false);
