var {
  Services
} = ChromeUtils.import("resource://gre/modules/Services.jsm");

var colors_fg = new Array(QCGlobals.nQC_MAX_LEVELS);
var colors_bg = new Array(QCGlobals.nQC_MAX_LEVELS);

var _elementIDs = ["graphicalquoting", "colortext", "colorbackground",
  "bordermode", "bordercolor", "borderwidth", "borderstyle",
  "showbordertop", "showborderleft", "showborderright",
  "showborderbottom", "collapseborders", "hidesignatures",
  "signaturecolor", "siglinkcolor", "colorhtmlmsg",
  "displaystruct", "hidestructdelimiters", "msgtextcolor",
  "msgbgcolor", "usermsgcolors", "msglinkcolor", "msglinkhovercolor"
];

var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

var bundle_qcsettings = Services.strings.createBundle("chrome://quotecolors/locale/qc_options.properties");

function init() {
  // ignore persisted height/width values of options dialog
  document.getElementById("qcsettings").removeAttribute("width");
  document.getElementById("qcsettings").removeAttribute("height");

  var elementgq = document.getElementById("graphicalquoting");
  if (!elementgq.checked) // graphical quoting is disabled by user...
  {
    if (pref.getBoolPref("mailnews.display.disable_format_flowed_support") == false)
      elementgq.checked = true;
  }
  toggleGraphicalQuoting(elementgq.checked);

  toggleShowStructs(document.getElementById("displaystruct").checked);
  toggleUserMsgColors(document.getElementById("usermsgcolors").checked);

  updatePreview();

  // set text/background color of preview box
  updatePreviewTextAndBg();
}

function checkGraphicalQuoting() {
  var enablegq = document.getElementById("graphicalquoting").checked;

  // if graphical quoting is disabled -> ensure that format_flowed_support is disabled, too
  if (!enablegq) {
    if (pref.getBoolPref("mailnews.display.disable_format_flowed_support") == false)
      pref.setBoolPref("mailnews.display.disable_format_flowed_support", true);
  }
}

function checkThinDouble() {
  var graphicalquoting = document.getElementById("graphicalquoting").checked;
  var idx_borderstyle = parseInt(document.getElementById("borderstyle").value);
  var idx_borderwidth = parseInt(document.getElementById("borderwidth").value);
  // borderwidth "thin" and borderstyle "double" don't work together
  if(graphicalquoting && idx_borderstyle==0 && idx_borderwidth==0)
  {
    // get a reference to the prompt service component.
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
      .getService(Components.interfaces.nsIPromptService);
    // show an alert. For the first argument, supply the parent window. The second
    // argument is the dialog title and the third argument is the message
    // to display.
    promptService.alert(window, 
      bundle_qcsettings.GetStringFromName("confirmThinDoubleBorderTitle"), 
      bundle_qcsettings.GetStringFromName("confirmThinDoubleBorder"));
  }
}

function updatePreview() {
  // update color arrays with pref values
  for (var f = 0; f < QCGlobals.nQC_MAX_LEVELS; f++) {
    colors_fg[f] = pref.getCharPref("quotecolors.fg.l" + (f + 1));
    colors_bg[f] = pref.getCharPref("quotecolors.bg.l" + (f + 1));
  }

  var colortext = document.getElementById("colortext").checked;
  var colorbg = document.getElementById("colorbackground").checked;
  var graphicalquoting = document.getElementById("graphicalquoting").checked;

  var borderwidth, bordercolor, staticbordercolor, borderstyletop, borderstyleright;
  var borderstylebottom, borderstyleleft, borderstyle, collapseborders;
  if (graphicalquoting) {
    staticbordercolor = parseInt(document.getElementById("bordermode").value);
    if (staticbordercolor)
      bordercolor = pref.getCharPref("quotecolors.bordercolor");

    var index_borderstyle = parseInt(document.getElementById("borderstyle").value);
    borderstyle = QCGlobals.aQC_borderstyle[index_borderstyle];
    var index_borderwidth = parseInt(document.getElementById("borderwidth").value);
    borderwidth = QCGlobals.aQC_borderwidth[index_borderwidth];

    borderstyletop = document.getElementById("showbordertop").checked ? borderstyle : "none";
    borderstyleright = document.getElementById("showborderright").checked ? borderstyle : "none";
    borderstylebottom = document.getElementById("showborderbottom").checked ? borderstyle : "none";
    borderstyleleft = document.getElementById("showborderleft").checked ? borderstyle : "none";

  }
  collapseborders = document.getElementById("collapseborders").checked;

  for (var i = 0; i < QCGlobals.nQC_MAX_LEVELS; i++) {
    var cur_elm = document.getElementById("blocklevel" + (i + 1));
    cur_elm.style.color = (colortext ? colors_fg[i] : "inherit");
    cur_elm.style.backgroundColor = (colorbg ? colors_bg[i] : "inherit");

    var cur_qcelm = document.getElementById("qchar" + (i + 1));
    cur_qcelm.style.display = "inline";

    if (!collapseborders) cur_elm.style.padding = "0ex 2ex 1ex 2ex";
    cur_elm.style.margin = "0.5em 0em 0em 0em";

    if (graphicalquoting) {
      cur_elm.style.borderColor = (staticbordercolor ? bordercolor : colors_fg[i]);
      cur_elm.style.borderWidth = borderwidth + "ex";
      cur_elm.style.borderStyle = borderstyletop + " " + borderstyleright + " " + borderstylebottom + " " + borderstyleleft;

      cur_qcelm.style.display = "none";
      if (i == 0) cur_elm.style.marginTop = "0em";

      if (collapseborders) {
        if (i > 0) {
          var leftmargin = (borderstyleleft == "none") ? 2.0 : 2.0 + borderwidth;
          var rightmargin = (borderstyleright == "none") ? 2.0 : 2.0 + borderwidth;
          cur_elm.style.marginLeft = "-" + leftmargin + "ex";
          cur_elm.style.marginRight = "-" + rightmargin + "ex";
        }
        cur_elm.style.padding = "0ex 2ex 0ex 2ex";
      }
    } else {
      cur_elm.style.borderStyle = "none";
      cur_elm.style.padding = "0.5em 0em 0em 0em";
      if (i == 0) cur_elm.style.marginTop = "1.5em";
    }
  }
  if (!graphicalquoting || collapseborders)
    document.getElementById("blocklevel5").style.paddingBottom = "0.5em";

}

function updatePreviewTextAndBg() {
  if (document.getElementById("usermsgcolors").checked) {
    var msgtextcolor = document.getElementById("msgtextcolor").getAttribute("color");
    var msgbgcolor = document.getElementById("msgbgcolor").getAttribute("color");
  } else {
    var msgtextcolor = pref.getCharPref("browser.display.foreground_color");
    var msgbgcolor = pref.getCharPref("browser.display.background_color");
  }
  document.getElementById("previewbox").style.color = msgtextcolor;
  document.getElementById("previewbox").style.backgroundColor = msgbgcolor;
}

function setDefaultColors() {
  for (var f = 0; f < QCGlobals.nQC_MAX_LEVELS; f++) {
    pref.lockPref("quotecolors.fg.l" + (f + 1));
    colors_fg[f] = pref.getCharPref("quotecolors.fg.l" + (f + 1));
    pref.unlockPref("quotecolors.fg.l" + (f + 1));
    pref.setCharPref("quotecolors.fg.l" + (f + 1), colors_fg[f]);

    pref.lockPref("quotecolors.bg.l" + (f + 1));
    colors_bg[f] = pref.getCharPref("quotecolors.bg.l" + (f + 1));
    pref.unlockPref("quotecolors.bg.l" + (f + 1));
    pref.setCharPref("quotecolors.bg.l" + (f + 1), colors_bg[f]);
  }

  updatePreview();
}

function toggleGraphicalQuoting(enable) {
  if (enable)
    document.getElementById("bc-gqenabled").removeAttribute("disabled");
  else
    document.getElementById("bc-gqenabled").setAttribute("disabled", true);
}

function toggleShowStructs(enable) {
  document.getElementById("bc-showstructs").setAttribute("disabled", !enable);
}

function toggleUserMsgColors(enable) {
  document.getElementById("bc-usermsgcolors").setAttribute("disabled", !enable);
}