var gbQCPrintMode = false;    // are we in printing mode?
var gnPrintMsgCnt = -1;

var QCPrefUpdateObserver = {
  register: function() {
    Services.prefs.getBranch("").addObserver("quotecolors.", this, false);
  },
  
  unregister: function() {
    Services.prefs.removeObserver("", this);
  },
  
  observe: function(subject, topic, data) {
    if (topic != "nsPref:changed")
    {
      return;
    }
    // console.log("Prefs observer triggered");
    QCObj.getQCPrefs();
    if(gDBView) ReloadMessage();
  }
};

var QCMailPaneConfigObserver = {
  sPrefName : "mail.pane_config.dynamic", // pref name to observe
  
  register: function() {
    this.oPrefServ = Components.classes["@mozilla.org/preferences-service;1"]
                               .getService(Components.interfaces.nsIPrefBranch);
    this.oPrefServ.QueryInterface(Components.interfaces.nsIPrefBranch);
    this.oPrefServ.addObserver(this.sPrefName, this, false);
  },
  
  unregister: function() {
    if(this.oPrefServ)
      this.oPrefServ.removeObserver(this.sPrefName, this);
  },
  
  observe: function(subject, topic, data) {
    // re-initialize message browser reference when mail pane config pref changes
    if(topic == "nsPref:changed")
      QCObj.initBrowserRef();
  }
};

function QCunloadMessenger()
{
  QCMailPaneConfigObserver.unregister();
  QCPrefUpdateObserver.unregister();
}

function QCunloadMsgWnd()
{
  QCPrefUpdateObserver.unregister();
}
