document.addEventListener('DOMContentLoaded', () => {
  restoreAllOptions()
  .then(() => { checkThinDouble(); })
  .then(() => { updatePreview(); });
});

OptionsList.forEach((option) => {
  if (option == "borderMode") {
    document.getElementById("bordermode0").addEventListener("change", (e) => {
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
    document.getElementById("bordermode1").addEventListener("change", (e) => {
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
} else {
    document.getElementById(option).addEventListener("change", (e) => {
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
  }
});

document.getElementById("reset").addEventListener("click", () => {
  resetAllOptions()
  .then(() => { waitAndUpdatePreview(); });
});

document.getElementById("reset_colors").addEventListener("click", () => {
  resetColorOptions()
  .then(() => { waitAndUpdatePreview(); });
});

document.getElementById("borderWidth").addEventListener("change", (e) => {
  checkThinDouble();
});

document.getElementById("borderStyle").addEventListener("change", (e) => {
  checkThinDouble();
});
