// console.log("[QuoteColors]: Run quotecolors_msgDisplay.js");

var QCObj = {
  // reference to message browser
  oMsgBody : null,
  
  // properties of current loaded message
  bIsHTMLMessage : false,
  bIsFormatFlowed : false,
  
  aPrefColorsFg : new Array(QCGlobals.nQC_MAX_LEVELS),
  aPrefColorsBg : new Array(QCGlobals.nQC_MAX_LEVELS),
  bHideStructDelim : false,
  
  
  // ########################################################################
  // basic object initialization
  // returns: void
  
  initMain : function()
  {
    // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: QCObj.initMain");

    // get preferences
    QCObj.getQCPrefs();

    // get message body
    this.oMsgBody = document.body;
    if (this.oMsgBody) {
      // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: document.body: true");
      // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: document.body: " + document.body);
    } else {
      // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: document.body: false");
      return;  // without body return
    }

    QCObj.applyColorsToMsg();
  },
  
  // ########################################################################
  // read Quote Colors preferences
  // returns: void
  
  getQCPrefs : function()
  {
    // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: OCObj.getQCPrefs");

    // ########################################################################
    // set value from user prefs

    this.bPrefColorText = options.colorText;
    this.bPrefColorBackground = options.colorBackground;

    this.aPrefColorsFg[0] = options.fg_l1;
    this.aPrefColorsBg[0] = options.bg_l1;

    this.aPrefColorsFg[1] = options.fg_l2;
    this.aPrefColorsBg[1] = options.bg_l2;

    this.aPrefColorsFg[2] = options.fg_l3;
    this.aPrefColorsBg[2] = options.bg_l3;

    this.aPrefColorsFg[3] = options.fg_l4;
    this.aPrefColorsBg[3] = options.bg_l4;

    this.aPrefColorsFg[4] = options.fg_l5;
    this.aPrefColorsBg[4] = options.bg_l5;

    this.sPrefBorderColor = options.borderColor;
    var nIdxBorderWidth = options.borderWidth;
    this.nBorderWidth = QCGlobals.aQC_borderwidth[nIdxBorderWidth];
    this.nPrefBorderMode = options.borderMode;
    var nIdxBorderStyle = options.borderStyle;
    var sBorderStyle = QCGlobals.aQC_borderstyle[nIdxBorderStyle];
    this.bPrefBorderLeftEn = options.borderposition_left;
    this.bPrefBorderRightEn = options.borderposition_right;
    this.sBorderLeftStyle = this.bPrefBorderLeftEn ? sBorderStyle : "none";
    this.sBorderRightStyle = this.bPrefBorderRightEn ? sBorderStyle : "none";
    this.sBorderTopStyle = options.borderposition_top ? sBorderStyle : "none";
    this.sBorderBottomStyle = options.borderposition_bottom ? sBorderStyle : "none";
    this.bPrefCollapseBorders = options.collapseBorders;

    this.bPrefColorHTMLMsg = options.colorHTMLmessages;

    this.bPrefUseCustomMsgColors = options.usermsgcolors;
    this.sPrefMsgTextColor = options.messagetextcolor;
    this.sPrefMsgBgColor = options.messagebgcolor;
    this.sPrefMsgLinkColor = options.messagelinkcolor;
    this.sPrefMsgLinkHoverColor = options.messagelinkhovercolor;
    this.sPrefSigColor = options.signaturecolor;
    this.sPrefSigLinkColor = options.signaturelinkcolor;

    this.bPrefHideSignatures = options.hidesignatures;
    this.bPrefHideStructDelim = options.hidestructdelimiters;

  },

  // ########################################################################
  // generate CSS that will be inserted into mail message
  // returns: string
  
  generateStyleBlock : function(bMsgContainsQuotes)
  {
    // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: generateStyleBlock");
    // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: bMsgContainsQuotes:" + bMsgContainsQuotes);

    const sBqSelector = "blockquote[type=cite] ";
    const sBqSelector5 = sBqSelector + sBqSelector + sBqSelector + sBqSelector + sBqSelector;
    
    // sample line for prefers-color-scheme
    // not yet used
    // var sStyleBlock = '@media (prefers-color-scheme: dark) { body { background-color: red;}}';
    
    var sStyleBlock = '';
    
    if(bMsgContainsQuotes)
    {
      if( (this.bIsHTMLMessage && this.bPrefColorHTMLMsg) || !this.bIsHTMLMessage)
      {
      
        for(var i=0; i<QCGlobals.nQC_MAX_LEVELS; i++)
        {
          var sBqSelectorLevel = '';
          for(var j=0; j<=i; j++) {
            sBqSelectorLevel += sBqSelector;
          }
          
          sStyleBlock += sBqSelectorLevel + ", " + sBqSelector5 + sBqSelectorLevel;
          sStyleBlock += "{";
          
          // text color
          sStyleBlock += "color:" + ( this.bPrefColorText ? this.aPrefColorsFg[i] : "inherit" ) + " !important;";
          
          // background color
          if(this.bPrefColorBackground)
            sStyleBlock += "background-color:" + this.aPrefColorsBg[i] + " !important;";
          
          // only add/style borders if graphical quoting is enabled
          if(this.bGraphQuotEn)
          {
            sStyleBlock += "border-color:" +
                            ( (this.nPrefBorderMode == false) ? this.aPrefColorsFg[i] : this.sPrefBorderColor )
                            + " !important;";
            sStyleBlock += "border-width:"+this.nBorderWidth+"ex !important;"
            sStyleBlock += "border-style:"+this.sBorderTopStyle+" "+this.sBorderRightStyle
                            +" "+this.sBorderBottomStyle+" "+this.sBorderLeftStyle+" !important;";
            
            if(this.bPrefCollapseBorders)
            {
              if(i>0)
              {
                var leftmargin = !this.bPrefBorderLeftEn ? 1.0 : 1.0;
                var rightmargin = !this.bPrefBorderRightEn ? 1.0 : 1.0;
                sStyleBlock += "margin-left:-"+leftmargin+"ex;margin-right:-"+rightmargin+"ex;";
              }
              else
                sStyleBlock += "margin-block: 1ex !important; padding: 0.4ex 1ex !important;";
            }
            else
            {
              sStyleBlock += "margin-block: 1ex !important; padding: 0.4ex 1ex !important;";
            }

          }
          else // non-graphical quoting
          {
            sStyleBlock += "border:none !important;";
            sStyleBlock += "padding:0em !important;";
          }
          
          sStyleBlock += "}\n";
        } // for loop

        if(this.bPrefCollapseBorders)
          sStyleBlock += "blockquote[type=cite] pre{margin-left:0em !important;margin-right:0em !important;}\n";
      }
    }

    // set other messages styles (if enabled)
    if(this.bPrefUseCustomMsgColors)
    {
      sStyleBlock += "a:link {color: "+this.sPrefMsgLinkColor+";}\n";
      sStyleBlock += "a:link:hover {color: "+this.sPrefMsgLinkHoverColor+";}\n";
      
      if(!this.bPrefHideSignatures)
      {
        sStyleBlock += ".moz-txt-sig, .moz-signature {color: "+this.sPrefSigColor+";}\n";
        sStyleBlock += ".moz-txt-sig > a, .moz-signature > a {color: "+this.sPrefSigLinkColor+";}\n";
      }
    }

    if(this.bPrefHideSignatures)
      sStyleBlock += ".moz-txt-sig, .moz-signature {display:none;}\n";

    if(this.bHideStructDelim)
      sStyleBlock += ".moz-txt-tag {display:none !important;}\n";

    return sStyleBlock;
  },
  
  applyColorsToMsg : function()
  {
    // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: applyColorsToMsg");

    var elmBody = this.oMsgBody;
    // does not seem to be a valid message
    if(!elmBody) return;

    var elmDiv = null;
    var nextElm = elmBody.firstChild;
    while( nextElm )
    {
      // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: nextElm");
      if( nextElm.nodeName == "DIV" && nextElm.hasAttribute("class") )
      {
        // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: div class");
        elmDiv = nextElm;
        break;
      }
      nextElm = nextElm.nextSibling;
    }

    if(!elmDiv)
    {
      // empty message, only set background color
      if(QCObj.bPrefUseCustomMsgColors)
        elmBody.bgColor = QCObj.sPrefMsgBgColor;
      return;
    }

    // determine message type: HTML or plain text (flowed or fixed)
    switch( elmDiv.getAttribute("class") )
    {
      case "moz-text-html":
        // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: moz-text-html");
        QCObj.bIsHTMLMessage = true;
        QCObj.bIsFormatFlowed = false;
        break;
      case "moz-text-plain":
        // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: moz-text-plain");
        QCObj.bIsHTMLMessage = false;
        QCObj.bIsFormatFlowed = false;
        break;
      case "moz-text-flowed":
        // console.log("[QuoteColors] [quotecolors_msgDisplay.js]: moz-text-flowed");
        QCObj.bIsHTMLMessage = false;
        QCObj.bIsFormatFlowed = true;
        break;
      default:
        return;
    }

    // check if there are any quotes in the message
    var bmsgcontainsquotes = false;
    if( this.oMsgBody.getElementsByTagName("blockquote").item(0) )
      bmsgcontainsquotes = true;

    QCObj.bGraphQuotEn = true;

    /*
    // is graphical quoting active?
    QCObj.bGraphQuotEn =
      ( QCObj.bIsHTMLMessage
        || QCObj.objnsIPrefBranch.getBoolPref("mail.quoted_graphical")
        || (!QCObj.objnsIPrefBranch.getBoolPref("mailnews.display.disable_format_flowed_support")
            && QCObj.bIsFormatFlowed)
      );
    // are struct delimiters enabled (MailNews option)?
    if( QCObj.bPrefHideStructDelim && QCObj.objnsIPrefBranch.getBoolPref("mail.display_struct") )
    */

    if(QCObj.bPrefHideStructDelim)
    {
      QCObj.bHideStructDelim = true;
    }

    // set text and background colors if enabled
    if(QCObj.bPrefUseCustomMsgColors)
    {
      var bgset = elmBody.hasAttribute("bgcolor");
      var textset = elmBody.hasAttribute("text");

      if(!bgset && !textset)
      {
        elmBody.bgColor = QCObj.sPrefMsgBgColor;
        elmBody.text = QCObj.sPrefMsgTextColor;
      }
    }

    // generate the style block, create a new style element
    // and finally add it to the "head" of message
    var sStyleContent = QCObj.generateStyleBlock(bmsgcontainsquotes);

    var qrStyle = document.createElement('style');
    qrStyle.classList.add('quotecolors_msgDisplay');
    //  qrStyle.media = 'screen';
    qrStyle.textContent = sStyleContent;
    if (document.head) {
        document.head.append(qrStyle);
    }
    else {
        var root = document.documentElement;
        root.append(qrStyle);
        var observer = new MutationObserver(() => {
            if (document.head) {
                observer.disconnect();
                if (qrStyle.isConnected) {
                    document.head.append(qrStyle);
                }
            }
        });
        observer.observe(root, { childList: true });
    }
  }

};

QCObj.initMain();
