var options = {};
var composeCss = "";

var msgDisplayScriptsPromise;
var composeScriptsPromise;
var composeCssPromise;

var QCGlobals = {
  // border widths in unit "ex" (correspond to "thin", "medium" and "thick")
  aQC_borderwidth: [0.1667, 0.5, 0.8333],
  // border styles
  aQC_borderstyle: ["double", "solid", "dashed", "dotted"],
  // maximum quote levels - NOT used on all arrays so search for "5" in code additionally
  nQC_MAX_LEVELS: 5
}

var ComposeCssObj = {
  aPrefColorsFg: new Array(QCGlobals.nQC_MAX_LEVELS),
  aPrefColorsBg: new Array(QCGlobals.nQC_MAX_LEVELS),

  // ########################################################################
  // basic object initialization

  initMain: function() {
    // console.log("[QuoteColors] [background.js]: ComposeCssObj.initMain");

    // get preferences
    ComposeCssObj.getQCPrefs();

    return ComposeCssObj.generateStyleBlock();
  },

  // ########################################################################
  // read Quote Colors preferences
  // returns: void

  getQCPrefs: function() {
    // console.log("[QuoteColors] [background.js]: ComposeCssObj.getQCPrefs");

    // ########################################################################
    // set value from user prefs

    this.bPrefColorText = options.colorText;
    this.bPrefColorBackground = options.colorBackground;

    this.aPrefColorsFg[0] = options.fg_l1;
    this.aPrefColorsBg[0] = options.bg_l1;

    this.aPrefColorsFg[1] = options.fg_l2;
    this.aPrefColorsBg[1] = options.bg_l2;

    this.aPrefColorsFg[2] = options.fg_l3;
    this.aPrefColorsBg[2] = options.bg_l3;

    this.aPrefColorsFg[3] = options.fg_l4;
    this.aPrefColorsBg[3] = options.bg_l4;

    this.aPrefColorsFg[4] = options.fg_l5;
    this.aPrefColorsBg[4] = options.bg_l5;

    this.sPrefBorderColor = options.borderColor;
    var nIdxBorderWidth = options.borderWidth;
    this.nBorderWidth = QCGlobals.aQC_borderwidth[nIdxBorderWidth];
    this.nPrefBorderMode = options.borderMode;
    var nIdxBorderStyle = options.borderStyle;
    var sBorderStyle = QCGlobals.aQC_borderstyle[nIdxBorderStyle];
    this.bPrefBorderLeftEn = options.borderposition_left;
    this.bPrefBorderRightEn = options.borderposition_right;
    this.sBorderLeftStyle = this.bPrefBorderLeftEn ? sBorderStyle : "none";
    this.sBorderRightStyle = this.bPrefBorderRightEn ? sBorderStyle :
    "none";
    this.sBorderTopStyle = options.borderposition_top ? sBorderStyle :
      "none";
    this.sBorderBottomStyle = options.borderposition_bottom ? sBorderStyle :
      "none";
    this.bPrefCollapseBorders = options.collapseBorders;

    this.bPrefColorHTMLMsg = options.colorHTMLmessages;

    this.bPrefUseCustomMsgColors = options.usermsgcolors;
    this.sPrefMsgTextColor = options.messagetextcolor;
    this.sPrefMsgBgColor = options.messagebgcolor;
    this.sPrefMsgLinkColor = options.messagelinkcolor;
    this.sPrefMsgLinkHoverColor = options.messagelinkhovercolor;
    this.sPrefSigColor = options.signaturecolor;
    this.sPrefSigLinkColor = options.signaturelinkcolor;

    this.bPrefHideSignatures = options.hidesignatures;
    this.bPrefHideStructDelim = options.hidestructdelimiters;

    this.bPrefEnableQuotecolorsOnCompose = options
      .enableQuotecolorsOnCompose;
    this.bPrefEnableUsermsgcolorsOnCompose = options
      .enableUsermsgcolorsOnCompose;
  },

  // ########################################################################
  // generate CSS that will be inserted into mail message
  // returns: string

  generateStyleBlock: function() {
    // console.log("[QuoteColors] [background.js]: generateStyleBlock");

    var sStyleBlock = '';
    ComposeCssObj.bGraphQuotEn = true;

    if (this.bPrefEnableQuotecolorsOnCompose) {
      const sBqSelector = "blockquote[type=cite] ";
      const sBqSelector5 = sBqSelector + sBqSelector + sBqSelector +
        sBqSelector + sBqSelector;

      // sample line for prefers-color-scheme
      // not yet used
      // var sStyleBlock = '@media (prefers-color-scheme: dark) { body { background-color: red;}}';

      for (var i = 0; i < QCGlobals.nQC_MAX_LEVELS; i++) {
        var sBqSelectorLevel = '';
        for (var j = 0; j <= i; j++) {
          sBqSelectorLevel += sBqSelector;
        }

        sStyleBlock += sBqSelectorLevel + ", " + sBqSelector5 +
          sBqSelectorLevel;
        sStyleBlock += "{";

        // text color
        sStyleBlock += "color:" + (this.bPrefColorText ? this.aPrefColorsFg[
          i] : "inherit") + ";";

        // background color
        if (this.bPrefColorBackground)
          sStyleBlock += "background-color:" + this.aPrefColorsBg[i] + ";";

        // only add/style borders if graphical quoting is enabled
        if (this.bGraphQuotEn) {
          sStyleBlock += "border-color:" +
            ((this.nPrefBorderMode == false) ? this.aPrefColorsFg[i] : this
              .sPrefBorderColor) +
            ";";
          sStyleBlock += "border-width:" + this.nBorderWidth + "ex;"
          sStyleBlock += "border-style:" + this.sBorderTopStyle + " " + this
            .sBorderRightStyle +
            " " + this.sBorderBottomStyle + " " + this.sBorderLeftStyle +
            ";";

          if (this.bPrefCollapseBorders) {
            if (i > 0) {
              var leftmargin = !this.bPrefBorderLeftEn ? 1.0 : 1.0;
              var rightmargin = !this.bPrefBorderRightEn ? 1.0 : 1.0;
              sStyleBlock += "margin-left:-" + leftmargin +
                "ex;margin-right:-" + rightmargin + "ex;";
            } else
              sStyleBlock += "margin-block: 1ex; padding: 0.4ex 1ex;";
          } else {
            sStyleBlock += "margin-block: 1ex; padding: 0.4ex 1ex;";
          }

        } else // non-graphical quoting
        {
          sStyleBlock += "border:none !important;";
          sStyleBlock += "padding:0em !important;";
        }

        sStyleBlock += "}\n";
      } // for loop

      if (this.bPrefCollapseBorders)
        sStyleBlock +=
        "blockquote[type=cite] pre{margin-left:0em;margin-right:0em;}\n";
    }

    if (this.bPrefUseCustomMsgColors && this
      .bPrefEnableUsermsgcolorsOnCompose) {
      // set text and background colors if enabled
      sStyleBlock += "body {color: " + ComposeCssObj.sPrefMsgTextColor +
        "; background: " + ComposeCssObj.sPrefMsgBgColor + ";}\n";

      // set link colors if enabled
      sStyleBlock += "a:link {color: " + this.sPrefMsgLinkColor + ";}\n";
      sStyleBlock += "a:link:hover {color: " + this.sPrefMsgLinkHoverColor +
        ";}\n";

      // set signature colors if enabled
      sStyleBlock += ".moz-txt-sig, .moz-signature {color: " + this
        .sPrefSigColor + ";}\n";
      sStyleBlock += ".moz-txt-sig > a, .moz-signature > a {color: " + this
        .sPrefSigLinkColor + ";}\n";
    }

    return sStyleBlock;
  },
};

function reloadOption(id) {
  return messenger.storage.local.get(id).then((res) => {
    if (res[id] != undefined)
      options[id] = res[id];
    else
      options[id] = DefaultOptions[id];
  }, defaultError);
}

async function reloadAllOptions() {
  await reloadOption("colorText");
  await reloadOption("colorBackground");

  await reloadOption("fg_l1");
  await reloadOption("fg_l2");
  await reloadOption("fg_l3");
  await reloadOption("fg_l4");
  await reloadOption("fg_l5");
  await reloadOption("bg_l1");
  await reloadOption("bg_l2");
  await reloadOption("bg_l3");
  await reloadOption("bg_l4");
  await reloadOption("bg_l5");

  await reloadOption("borderMode");
  await reloadOption("borderColor");
  await reloadOption("borderStyle");
  await reloadOption("borderWidth");
  await reloadOption("borderposition_bottom");
  await reloadOption("borderposition_left");
  await reloadOption("borderposition_right");
  await reloadOption("borderposition_top");
  await reloadOption("collapseBorders");

  await reloadOption("colorHTMLmessages");

  await reloadOption("usermsgcolors");
  await reloadOption("messagetextcolor");
  await reloadOption("messagebgcolor");
  await reloadOption("messagelinkcolor");
  await reloadOption("messagelinkhovercolor");
  await reloadOption("signaturecolor");
  await reloadOption("signaturelinkcolor");

  await reloadOption("hidesignatures");
  await reloadOption("hidestructdelimiters");

  await reloadOption("enableQuotecolorsOnCompose");
  await reloadOption("enableUsermsgcolorsOnCompose");
}

function registerCss() {
  // console.log("[QuoteColors]: [registerCss]: composeCss: \n" + composeCss);
  if (!composeCss)
    composeCss = "";
  composeCssPromise = messenger.composeScripts.register({
    css: [{
      code: composeCss,
    }],
  });
}

function registerScripts() {
  let msgDisplayContentScripts = {
    js: [{
        code: "var options = " + JSON.stringify(options) + ";",
      },
      {
        code: "var QCGlobals = " + JSON.stringify(QCGlobals) + ";",
      },
      {
        file: "/scripts/quotecolors_msgDisplay.js",
      }
    ]
  };
  msgDisplayScriptsPromise = messenger.messageDisplayScripts.register(
    msgDisplayContentScripts);
}

async function unregisterCss() {
  await composeCssPromise.then(css => css.unregister());
}

async function unregisterScripts() {
  await msgDisplayScriptsPromise.then(script => script.unregister());
}

async function reset() {
  await unregisterCss();
  await unregisterScripts();
  await init();
}

async function init() {
  // await reloadAllOptions is necessary before composeCss = ...
  await reloadAllOptions();
  composeCss = ComposeCssObj.initMain();
  reloadAllOptions().then(registerCss).then(registerScripts);
}

messenger.storage.onChanged.addListener(reset);
init();