document.addEventListener('DOMContentLoaded', () => {
  //console.log("[QuoteColors] [options_listeners.js]: DOMContentLoaded, restoreAllOptions()");
  restoreAllOptions()
  .then(() => { checkThinDouble(); })
  .then(() => { updatePreview(); });
});

OptionsList.forEach((option) => {
  //console.log("option: " + option);
  if (option == "borderMode") {
    document.getElementById("bordermode0").addEventListener("change", (e) => {
      //console.log("[QuoteColors] [options_listeners.js]: Option borderMode-0 changed, saveOptions()");
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
    document.getElementById("bordermode1").addEventListener("change", (e) => {
      //console.log("[QuoteColors] [options_listeners.js]: Option borderMode-1 changed, saveOptions()");
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
} else {
    document.getElementById(option).addEventListener("change", (e) => {
      //console.log("[QuoteColors] [options_listeners.js]: Other Option changed, saveOptions()");
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
  }
});

document.getElementById("reset").addEventListener("click", () => {
  //console.log("[QuoteColors] [options_listeners.js]: Reset clicked, resetAllOptions()");
  resetAllOptions()
  .then(() => { waitAndUpdatePreview(); });
});

document.getElementById("reset_colors").addEventListener("click", () => {
  //console.log("[QuoteColors] [options_listeners.js]: Reset Light-Mode Colors clicked, resetLightmodeColorOptions()");
  resetLightmodeColorOptions()
  .then(() => { waitAndUpdatePreview(); });
});

document.getElementById("dm_reset_colors").addEventListener("click", () => {
  //console.log("[QuoteColors] [options_listeners.js]: Reset Dark-Mode Colors clicked, resetDarkmodeColorOptions()");
  resetDarkmodeColorOptions()
  .then(() => { waitAndUpdatePreview(); });
});

document.getElementById("borderWidth").addEventListener("change", (e) => {
  checkThinDouble();
});

document.getElementById("borderStyle").addEventListener("change", (e) => {
  checkThinDouble();
});
