/* -*- Mode: javascript; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Calendar code.
 *
 * The Initial Developer of the Original Code is
 *   Joey Minta <jminta@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Matthew Willis <lilmatt@mozilla.com>
 *   Ferdinand Grassmann <ferdinand@grassmann.info>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var { Services } = ChromeUtils.import("resource://gre/modules/Services.jsm");
var { cal } = ChromeUtils.import("resource://calendar/modules/calUtils.jsm");
 
Components.utils.import("resource://calendar/modules/calUtils.jsm");
//Components.utils.import("resource://fgprinters/modules/calXMLUtils.jsm");
//Components.utils.import("resource://fgprinters/modules/calPrintUtils.jsm");
Components.utils.import("resource://fgprinters/modules/calHtmlUtils.jsm");

 
/**
 * Prints a two column view of a week of events, much like a paper day-planner
 */ 
 
function FGcalWeekPrinter() {
}

var FGcalWeekPrinterID = Components.ID('{F5871754-CCBD-11DB-B295-29C955D89593}');
var FGcalWeekPrinterInterfaces = [Components.interfaces.calIPrintFormatter];
var FGcalWeekPrinterContractID = "@mozilla.org/calendar/printformatter;1?type=fgweekplan";
var FGcalWeekPrinterDescription = "Calendar Week Print Formatter";

FGcalWeekPrinter.prototype = {
	classID: FGcalWeekPrinterID,
	QueryInterface: ChromeUtils.generateQI([Ci.calIPrintFormatter]),
	
	
	
	get name() {
        return "FG " + cal.l10n.getAnyString("fgprinters", "fgprinters", "weekview", []); 
    },

	formatToHtml : function FGweekPrint_format(aStream, aStart, aEnd, aCount, aItems, aTitle) {

		// Parse the template file
		let html = cal.xml.parseFile("chrome://fgprinters/skin/printing/empty.html");
	
		// Set page title
		html.getElementsByTagName("title")[0].textContent = aTitle;
	
		// Set the style sheet
		this.setupStyleSheet(html);

		let rowsSameHeight = Services.prefs.getBoolPref("fgprinters.weekly.rowssameheight", false);
	
		let body = html.getElementsByTagName('body')[0];

		let printtitle = Services.prefs.getBoolPref("fgprinters.printtitle", false);
		let subTitle = Services.prefs.getCharPref("fgprinters.subtitle", "");
		if (printtitle && aTitle) {
			let p_aTitle = html.createElementNS("http://www.w3.org/1999/xhtml","p");
			p_aTitle.className = 'main-title';
			p_aTitle.textContent = aTitle;
			body.appendChild(p_aTitle);
		}
		if (subTitle) {
			let p_subTitle = html.createElementNS("http://www.w3.org/1999/xhtml","p");
			p_subTitle.className = 'sub-title';
			p_subTitle.textContent = subTitle;
			body.appendChild(p_subTitle);
		}

		// helper: returns the passed item's startDate, entryDate or dueDate, in
		//         that order. If the item doesn't have one of those dates, this
		//         doesn't return.
		function hasUsableDate(item) {
			return item.startDate || item.entryDate || item.dueDate;
		}

		// Clean out the item list so it only contains items we will want to
		// include in the printout.
		let filteredItems = aItems.filter(hasUsableDate);

		let calIEvent = Components.interfaces.calIEvent;
		let calITodo = Components.interfaces.calITodo
		let defaultTimezone = null;
		try {
			defaultTimezone = cal.dtz.defaultTimezone; 
		} catch(ex) {}

		function compareItems(a, b) {
			// Sort tasks before events
			if (a instanceof calIEvent && b instanceof calITodo) {
				return 1;
			}
			if (a instanceof calITodo && b instanceof calIEvent) {
				return -1;
			}	

			if (a instanceof calIEvent) {
				if (a.startDate.isDate && b.startDate.isDate) {
					return a.startDate.compare(b.startDate);
				}
				if (a.startDate.isDate) {
					let tmpd = b.startDate.clone();
					tmpd.isDate = true;
					try {
						tmpd.normalize();
					} catch(ex) {}
					if (defaultTimezone) {
						try {
							tmpd = tmpd.getInTimezone(defaultTimezone);
						} catch(ex) {}
					}
					if (a.startDate.compare(tmpd) == 0) return -1;
				}
				if (b.startDate.isDate) {
					let tmpd = a.startDate.clone();
					tmpd.isDate = true;
					try {
						tmpd.normalize();
					} catch(ex) {}
					if (defaultTimezone) {
						try {
							tmpd = tmpd.getInTimezone(defaultTimezone);
						} catch(ex) {}
					}
					if (b.startDate.compare(tmpd) == 0) return 1;
				}
			}
        
			if (a instanceof calIEvent) {
				let startCompare = a.startDate.compare(b.startDate);
				if (startCompare != 0) {
					return startCompare;
				}
				return a.endDate.compare(b.endDate);
			}
			let aDate = a.entryDate || a.dueDate;
			let bDate = b.entryDate || b.dueDate;
			return aDate.compare(bDate);
		}
		let sortedList = filteredItems.sort(compareItems);
	
		let sbs = Components.classes["@mozilla.org/intl/stringbundle;1"]
							.getService(Components.interfaces.nsIStringBundleService);
		let props = sbs.createBundle("chrome://calendar/locale/calendar.properties");
	
		let weekFormatter = null;
		try {
			weekFormatter = Components.classes["@mozilla.org/calendar/weektitle-service;1"]
										.getService(Components.interfaces.calIWeekTitleService);
		} catch(ex) {
			weekFormatter = Components.classes["@mozilla.org/calendar/weekinfo-service;1"]
										.getService(Components.interfaces.calIWeekInfoService);
		}
	
		// A place to cache the string for "All Day" events later if we need it.
		let mAllDayString = null;
		
		// Start at the beginning of the week that aStart is in, and loop until
		// we're at aEnd. In the loop we build the HTML table for each day, and
		// get the day's items using getDayTd().
		let start = aStart || sortedList[0].startDate || sortedList[0].entryDate ||
					sortList[0].dueDate;
		cal.ASSERT(start, "can't find a good starting date to print");
	
		let lastItem = sortedList[sortedList.length-1];
		let end = aEnd || lastItem.startDate || lastItem.entryDate ||
				lastItem.dueDate;
		cal.ASSERT(end, "can't find a good ending date to print");
	
		let date = start.startOfWeek;
		let startOfWeek = Services.prefs.getIntPref("calendar.week.start", 0);
		date.day += startOfWeek;
		try {
			date.normalize();
		} catch(ex) {}
		// Make sure we didn't go too far ahead
		if (date.compare(start) == 1) {
			date.day -= 7;
			try {
				date.normalize();
			} catch(ex) {}
		}
	
		const weekPrefix = "calendar.week.";
		let prefNames = ["d0sundaysoff", "d1mondaysoff", "d2tuesdaysoff",
						"d3wednesdaysoff", "d4thursdaysoff", "d5fridaysoff", "d6saturdaysoff"];
		let defaults = [true, false, false, false, false, false, true];
	
	
		while(date.compare(end) == -1) {
			let weekno = weekFormatter.getWeekTitle(date);
			let weekTitle = props.formatStringFromName('WeekTitle', [weekno], 1);
			
			//<table border='0' width='100%' class='main-table'>
			//	<tr> 
			//		<td align='center' valign='bottom'>{weekTitle}</td>
			//	</tr>
			//</table>
			let weekTitleTable = html.createElementNS("http://www.w3.org/1999/xhtml","table");
			weekTitleTable.className = 'main-table';
			weekTitleTable.setAttribute('border', '0');
			weekTitleTable.setAttribute('width', '100%');
			body.appendChild(weekTitleTable);
			let weekTitleTr = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
			let weekTitleTd = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			weekTitleTd.setAttribute('align', 'center');
			weekTitleTd.setAttribute('valign', 'bottom');
			weekTitleTd.textContent = weekTitle;
			weekTitleTr.appendChild(weekTitleTd);
			weekTitleTable.appendChild(weekTitleTr);
			
			//<table width='100%' height="90%" border='solid 1px;'/>
			let mainWeek = html.createElementNS("http://www.w3.org/1999/xhtml","table");
			mainWeek.setAttribute('width', '100%');
			mainWeek.setAttribute('height', '90%');
			mainWeek.setAttribute('border', 'solid 1px');
	
			// Create the <td> for each day, and put it into an array.
			let dayTds = new Array();
			for (let i = 0; i < 7 ; i++) {
				let isOff = Services.prefs.getCharPref(weekPrefix+prefNames[date.weekday], defaults[date.weekday]);
			
				dayTds[date.weekday] = this.getDayTd(html, date, sortedList, isOff);
				date.day += 1;
				try {
					date.normalize();
				} catch(ex) {}
			}
			let monRow = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
			if (rowsSameHeight) {
				monRow.setAttribute('height', '33%'); //<tr height="33%"/>;
			} 
			monRow.appendChild(dayTds[1]); // Monday
			monRow.appendChild(dayTds[4]); // Thursday
			mainWeek.appendChild(monRow);
	
			let tueRow = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
			if (rowsSameHeight) {
				tueRow.setAttribute('height', '33%'); //<tr height="33%"/>;
			} 
			tueRow.appendChild(dayTds[2]); // Tuesday
			tueRow.appendChild(dayTds[5]); // Friday
			mainWeek.appendChild(tueRow);
	
			let wedRow = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
			if (rowsSameHeight) {
				wedRow.setAttribute('height', '33%'); // <tr height="33%"/>;
			} 
			wedRow.appendChild(dayTds[3]); // Wednesday
	
			// Saturday and Sunday are half-size
			let satSunTd = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			if (rowsSameHeight) {
				satSunTd.setAttribute('height', '33%'); // <td height="33%"/>;
			} 
			//<table border="1" width="100%" height="100%"/>;
			let weekendTable = html.createElementNS("http://www.w3.org/1999/xhtml","table");
			weekendTable.setAttribute('border', '1');
			weekendTable.setAttribute('width', '100%');
			weekendTable.setAttribute('height', '100%');
	
			let satRow = html.createElementNS("http://www.w3.org/1999/xhtml","tr");// <tr valign='top'/>;
			satRow.setAttribute('valign', 'top');
			satRow.appendChild(dayTds[6]); // Saturday
			weekendTable.appendChild(satRow);
	
			let sunRow = html.createElementNS("http://www.w3.org/1999/xhtml","tr");// <tr valign='top'/>;
			sunRow.setAttribute('valign', 'top');
			sunRow.appendChild(dayTds[0]); // Sunday
			weekendTable.appendChild(sunRow);
	
			satSunTd.appendChild(weekendTable);
			wedRow.appendChild(satSunTd);
			mainWeek.appendChild(wedRow);
	
			body.appendChild(mainWeek);
			// Make sure each month gets put on its own page
			//<br style="page-break-after: always;"/>
			let tmpBr = html.createElementNS("http://www.w3.org/1999/xhtml","br");
			tmpBr.setAttribute('style', 'page-break-after: always;');
			body.appendChild(tmpBr);
		}
	
		// Stream out the resulting HTML
		let htmlString = cal.xml.serializeDOM(html);		
		//Components.utils.reportError(htmlString);
		let convStream = Components.classes["@mozilla.org/intl/converter-output-stream;1"]
                                   .createInstance(Components.interfaces.nsIConverterOutputStream);
		convStream.init(aStream, 'UTF-8', 0, 0x0000);
		convStream.writeString(htmlString);
	},
	
	/**
	 * Given a calIDateTime and an array of items, this function creates an HTML
	 * table containing the items, using the appropriate formatting and colours.
	 */
	getDayTd : function FGweekPrint_getDayTable(document, aDate, aItems, isOff) {
		// mainTd is the <td> element from the parent HTML table that will hold
		// the child HTML tables containing the date string and this day's items.
		// <td border='1px solid black;' width="50%" valign='top'/>
		let mainTd = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		mainTd.setAttribute('border', '1px solid black;');
		mainTd.setAttribute('width', '50%');
		mainTd.setAttribute('valign', 'top');
		
		let dateFormatter = Components.classes["@mozilla.org/calendar/datetime-formatter;1"]
									.getService(Components.interfaces.calIDateTimeFormatter);
		let defaultTimezone = null;
		try {
			defaultTimezone = cal.dtz.defaultTimezone;
		} catch(ex) {}
		let dateString = null;
		try {
			dateString = dateFormatter.formatDateLong(aDate.getInTimezone(defaultTimezone));
		} catch(ex) {
			dateString = dateFormatter.formatDateLong(aDate);
		}
	
		// Add the formatted date string (in its own child HTML table)
		// <table class='day-name' width='100%' style='border: 1px solid black; border-collapse:collapse;'>
		//					<tr> 
		//						<td align='center' valign='bottom'>{dateString}</td>
		//					</tr>
		//				</table>
		let daynameTable = document.createElementNS("http://www.w3.org/1999/xhtml","table");
		daynameTable.className = 'day-name';
		daynameTable.setAttribute('width', '100%');
		daynameTable.setAttribute('style', 'border: 1px solid black; border-collapse:collapse;');
		let tmpTr = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
		daynameTable.appendChild(tmpTr);
		let tmpTd = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpTd.setAttribute('align', 'center');
		tmpTd.setAttribute('valign', 'bottom');
		tmpTd.textContent = dateString;
		tmpTr.appendChild(tmpTd);		
		mainTd.appendChild(daynameTable);
	
		let printAllDay = Services.prefs.getBoolPref("fgprinters.weekly.printallday", false);
		let printLocation = Services.prefs.getBoolPref("fgprinters.weekly.printlocation", true);
		let printDescription = Services.prefs.getBoolPref("fgprinters.weekly.printdescription", true);
		let printPriority = Services.prefs.getBoolPref("fgprinters.weekly.printpriority", true);
		let printStatus = Services.prefs.getBoolPref("fgprinters.weekly.printstatus", true);
		let printEndTime = Services.prefs.getBoolPref("fgprinters.weekly.printendtime", true);
		let noPrintTimesInMultiDay = Services.prefs.getBoolPref("fgprinters.weekly.noprinttimesinmultidayevents", false);
	
		let fsize = Services.prefs.getIntPref("fgprinters.weekly.fontsize", 26);
		let fsizet = Services.prefs.getIntPref("fgprinters.weekly.fontsizetime", 26);
		let obeyPrivacy = Services.prefs.getBoolPref("fgprinters.obeyprivacy", false);
		
		let oldcolour = Services.prefs.getBoolPref("fgprinters.weekly.oldcolour", false);
		
		// ADDED : print participants
		let printOrganizer = Services.prefs.getBoolPref("fgprinters.list.printorganizer", false);
		let printReqAttendees = Services.prefs.getBoolPref("fgprinters.list.printreqattendees", false);
		let printOptAttendees = Services.prefs.getBoolPref("fgprinters.list.printoptattendees", false);
		let printFyiAttendees = Services.prefs.getBoolPref("fgprinters.list.printfyiattendees", false);
		// ADDED : print calname
		let printCalname = Services.prefs.getBoolPref("fgprinters.list.printcalname", false);
		
		// Add the formatted items (in their child HTML table)
		let innerTable = document.createElementNS("http://www.w3.org/1999/xhtml","table");
		innerTable.setAttribute('width', '100%');
		innerTable.setAttribute('valign', 'top');
		if (isOff) { 
			innerTable.className = 'weekend';  //<table width='100%' valign='top' class="weekend"/>; 
		}
		//    let innerTable = <table width='100%' valign='top'/>;
		for (let item of aItems) {
			let sDate = item.startDate || item.entryDate || item.dueDate;
			let eDate = item.endDate || item.dueDate || item.entryDate;
			if (sDate) {
				try {
					sDate = sDate.getInTimezone(defaultTimezone);
				} catch(ex) {}
			}
			if (eDate) {
				try {
					eDate = eDate.getInTimezone(defaultTimezone);
				} catch(ex) {}
			} 
			
			// End dates are exclusive. Adjust the eDate accordingly.
			if (sDate && sDate.isDate && eDate) {
				eDate = eDate.clone();
				eDate.day -= 1;
				try {
					eDate.normalize();
				} catch(ex) {}
			}
	
			// If the item has no end date, or if the item's end date is aDate or
			// is before aDate, skip to the next item.
			if (!eDate || (eDate.compare(aDate) < 0)) {
				continue;
			}
	
			// No start date or a start date that's after the date we want is bad.
			if (!sDate || (sDate.compare(aDate) > 0)) {
				break;
			}
	
			function getStringForDate(aDate) {
				if (!aDate.isDate) {
					return dateFormatter.formatTime(aDate);
				}
	
				// We cache the string for "All Day" 'cause we're good like that.
				if (this.mAllDayString == null) {
					let sbs = Components.classes["@mozilla.org/intl/stringbundle;1"]
										.getService(Components.interfaces.nsIStringBundleService);
					let props = sbs.createBundle("chrome://calendar/locale/dateFormat.properties");
					this.mAllDayString = props.GetStringFromName("AllDay");
				}
				if (printAllDay) { return this.mAllDayString; } else { return ""; }
			}
	
			let time;
			if (sDate && eDate) {
				if (!sDate.isDate) {
					let startTime = "";
					let endTime = "";
					if (sDate.compare(aDate) < 0) {
						let dummyDate = sDate.clone();
						dummyDate.hour = 0;
						dummyDate.minute = 0;
						try {
							dummyDate.normalize();
						} catch(ex) {
						}
						startTime = getStringForDate(dummyDate);
						if (noPrintTimesInMultiDay) {
							startTime = "";
						}
					} else {
						startTime = getStringForDate(sDate);
					}
					if (eDate.compare(aDate) > 0) {
						let dummyDate = eDate.clone();
						dummyDate.hour = 23;
						dummyDate.minute = 59;
						try {
							dummyDate.normalize();
						} catch(ex) {
						}
						endTime = getStringForDate(dummyDate);
						if (noPrintTimesInMultiDay) {
							endTime = "";
						}
					} else {
						endTime = getStringForDate(eDate);
					}
					if (printEndTime) {
						time = startTime + '-' + endTime;
						if (time == "-") {
							time = "";
						}
					} else {
						time = startTime;
					}
				} else {
					time = getStringForDate(sDate);
				}
			} else if (sDate) {
				time = getStringForDate(sDate);
			} else if (eDate) {
				time = getStringForDate(eDate);
			}
	
			// Get calendar and category colours and apply them to the item's
			// table cell.
			let calColor = null;
			try {
				calColor = item.calendar.getProperty('color');
			} catch(ex) {
				let calMgr = Components.classes["@mozilla.org/calendar/manager;1"]
									.getService(Components.interfaces.calICalendarManager);
				calColor = calMgr.getCalendarPref(item.calendar, 'color'); 
			}        
			if (!calColor) {
				calColor = "#A8C2E1";
			}
			//let pb2 = Components.classes["@mozilla.org/Services.prefs-service;1"]
			//					.getService(Components.interfaces.nsIPrefBranch2);
			let catColor;
			try {
				catColor = Services.prefs.getCharPref("calendar.category.color."+item.getProperty("CATEGORIES").toLowerCase());
			} catch(ex) {}
			if (!catColor) {
				for (let cat of item.getCategories({})) {
					try {
						catColor = Services.prefs.getCharPref("calendar.category.color." + cat.toLowerCase());
						break; // take first matching
					} catch(ex) {}
				}
			}
	
			let borderType = 'solid';
			if (item.status && printStatus) {
				if (item.status == "TENTATIVE") {
					borderType = 'dotted';
				}
				if (item.status == "CANCELLED") {
					borderType = 'dashed';
				}
			}
			let style = null;
			if (!oldcolour) {
				style = 'font-size: '+fsize+'px; border: ' + borderType + ' ' + calColor + ' 4px; ';
				style += ' color: black; ';
				let tStyle = 'font-size: '+fsizet+'px; color: black; ';
				if (catColor) {
					style += 'border-right-width: 8px; border-right-color: ' + catColor + ';';
					style += 'border-top-color: ' + catColor + ';';
					catColor = 0;
				}
			} else {
				style = 'font-size: '+fsize+'px; font-weight: bold; background-color: ' + calColor + ';';
				style += ' color: ' + cal.getContrastingTextColor(calColor) + ';';
				let tStyle = 'font-size: '+fsizet+'px; font-weight: bold; background-color: ' + calColor + '; color: ' + cal.getContrastingTextColor(calColor) + ';';
				if (catColor) {
					style += ' border: solid ' + catColor + ' 2px;';
					catColor = 0;
				}
			}
			if (printPriority && item.priority && !oldcolour) {
				let prioCol = '';
				if (item.priority > 5) {
					prioCol = "#CFC";
				}
				if (item.priority == 5) {
					prioCol = "#FFC";
				}
				if (item.priority < 5) {
					prioCol = "#FCC";
				}
				style += 'background-color: ' + prioCol + ';';
			}
			let location = " ";
			let descr = " ";
			
			if (printLocation) {
				if (item.hasProperty('LOCATION')) {
					location = item.getProperty('LOCATION');
				}
			}
			if (printDescription) {
				if (item.hasProperty('DESCRIPTION')) {
					descr = item.getProperty('DESCRIPTION');
				}
			}
			let title = item.title;
			if (obeyPrivacy && (item.privacy == "PRIVATE" || item.privacy == "CONFIDENTIAL")) {
				title = " ";
				descr = " ";
				location = " ";
			}
			// ADDED calname :
			let can = " ";
			if (printCalname){
				can = item.calendar.getProperty('name');
			}
			
			// ADDED Organizer :
			let org = " ";
			if(printOrganizer) {
				try {
					org = item.organizer.commonName;
					if((!org) || (org == 'null')) {
						org = item.organizer.id;
					}
				} catch(e){}
			}
			let reqAtts = " ";
			// role= REQ-PARTICIPANT
			if(printReqAttendees) {
				try {
					for (let att of item.getAttendees({})) {
						if(att.role != 'REQ-PARTICIPANT') continue;
						if(reqAtts != " "){
							reqAtts += ", ";
						}
						
						let attName = att.commonName;
						if((!attName) || (attName == 'null')) {
							attName = att.id;
						}
						reqAtts += attName;
					}
				} catch(e){}
			}
			let optAtts = " ";
			// role=OPT-PARTICIPANT
			if(printOptAttendees) {
				try {
					for (let att of item.getAttendees({})) {
						if(att.role != 'OPT-PARTICIPANT') continue;
						if(optAtts != " "){
								optAtts += ", ";
						}
						
						let attName = att.commonName;
						if((!attName) || (attName == 'null')) {
							attName = att.id;
						}
						optAtts += attName;
					}
				} catch(e){}
			}
			let fyiAtts = " ";
			// role=NON-PARTICIPANT
			if(printFyiAttendees) {
				try {
					for (let att of item.getAttendees({})) {
						if(att.role != 'NON-PARTICIPANT') continue;
						if(fyiAtts != " "){
								fyiAtts += ", ";
						}
						
						let attName = att.commonName;
						if((!attName) || (attName == 'null')) {
							attName = att.id;
						}
						
						fyiAtts += attName;
					}
				} catch(e){}
			}
	
			//<tr width='100%'>
			let trItem = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
			trItem.setAttribute('width', '100%');
			//<td valign='top' align='left' width='100%' style={style}><span style={tStyle}>{time}</span>{title}
			let tdItem = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			tdItem.setAttribute('valign', 'top');
			tdItem.setAttribute('align', 'left');
			tdItem.setAttribute('width', '100%');
			tdItem.setAttribute('style', style);
			trItem.appendChild(tdItem);
			let tmpSpan = document.createElementNS("http://www.w3.org/1999/xhtml","span");
			tmpSpan.setAttribute('style', 'tStyle');
			tmpSpan.textContent = time + ' ';
			tdItem.appendChild(tmpSpan);
			tdItem.textContent += title;
			//<div class='desc'>{descr}</div>
			let descDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
			descDiv.className = 'desc';
			descDiv.textContent = descr;
			tdItem.appendChild(descDiv);
			//<div class='loc'>{location}</div>
			let locDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
			locDiv.className = 'loc';
			locDiv.textContent = location;
			tdItem.appendChild(locDiv);
			//<div class='calname'>{can}</div>
			let calnameDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
			calnameDiv.className = 'calname';
			calnameDiv.textContent = can;
			tdItem.appendChild(calnameDiv);
			//<div class='org'>{org}</div>
			let orgDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
			orgDiv.className = 'org';
			orgDiv.textContent = org;
			tdItem.appendChild(orgDiv);
			//<div class='atts'>
			let attsDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
			attsDiv.className = 'atts';
			attsDiv.textContent = org;
			tdItem.appendChild(attsDiv);
			//<span>{reqAtts}</span>
			let reqAttsSpan = document.createElementNS("http://www.w3.org/1999/xhtml","span");
			reqAttsSpan.textContent = reqAtts;
			attsDiv.appendChild(reqAttsSpan);
			//<span>{optAtts}</span>
			let optsAttsSpan = document.createElementNS("http://www.w3.org/1999/xhtml","span");
			optsAttsSpan.textContent = optAtts;
			attsDiv.appendChild(optsAttsSpan);
			//<span>{fyiAtts}</span>
			let fyiAttsSpan = document.createElementNS("http://www.w3.org/1999/xhtml","span");
			fyiAttsSpan.textContent = fyiAtts;
			attsDiv.appendChild(fyiAttsSpan);

			innerTable.appendChild(trItem);
		}
		//<tr height='100%'><td style="border:solid 1px red;"/></tr>
		let endTr = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
		endTr.setAttribute('height', '100%');
		let endTd = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		endTd.setAttribute('style', 'border:solid 1px red;');
		endTr.appendChild(endTd);
		innerTable.appendChild(endTr);
		mainTd.appendChild(innerTable);
		return mainTd;
	},
	
	setupStyleSheet: function FGweek_setupStyleSheet(html) {
		let fsizeday = Services.prefs.getIntPref("fgprinters.weekly.fontsizedayname", 20);
		let fsizetitle = Services.prefs.getIntPref("fgprinters.weekly.fontsizetitle", 20);
		let dnbk = Services.prefs.getCharPref("fgprinters.headcolour", "#f0f0f0");
		let wec = Services.prefs.getCharPref("fgprinters.weekendcolour", "#FFFFEE");
		let sansserif = Services.prefs.getBoolPref("fgprinters.sansserif", true);
		let fsizeloc = Services.prefs.getIntPref("fgprinters.weekly.fontsizelocation", 14);
		let fsizedesc = Services.prefs.getIntPref("fgprinters.weekly.fontsizedescription", 14);
		let printLocationRight = Services.prefs.getBoolPref("fgprinters.weekly.printlocationright", true);
		let fsizeglobaltitle = Services.prefs.getIntPref("fgprinters.fontsizetitle", 26);
		let fsizesubtitle = Services.prefs.getIntPref("fgprinters.fontsizesubtitle", 20);
		let fbodyheightpercent = Services.prefs.getIntPref("fgprinters.weekly.bodyheightpercent", 90);
    

		let style = "table { border-collapse:collapse;}\n";
		style = ".main-table { font-size: "+fsizetitle+"px; font-weight:bold;}\n";
		style += ".main-title { font-size: "+fsizeglobaltitle+"px; font-weight:bold; text-align: center; }\n";
		style += ".sub-title { font-size: "+fsizesubtitle+"px; font-weight:bold; text-align: center; }\n";
		style += ".day-name { border: 1px solid #000; background-color: "+dnbk+"; font-size: "+fsizeday+"px; font-weight: bold; }\n";
		if (sansserif) { style += "body, tr, td, table, p { font-family: Arial, sans-serif; }\n"; }
		style += ".weekend { background-color: "+wec+"; border:none;}\n";
		if (printLocationRight) {
			style += ".loc { font-size: "+fsizeloc+"px; text-align: right; }\n";
		} else {
			style += ".loc { font-size: "+fsizeloc+"px; text-align: left; }\n";
		}
		style += ".desc { font-size: "+fsizedesc+"px; text-align: left; }\n";
		style += ".org { font-size: "+fsizedesc+"px; text-align: left; font-weight:bold;}\n";
		style += ".atts { font-size: "+fsizedesc+"px; text-align: right; }\n";
		style += ".calname { font-size: "+fsizedesc+"px; text-align: left; font-style: italic;}\n";
		style += "body { height : "+fbodyheightpercent+"vh;}\n";
		
		html.getElementsByTagName('style')[0].textContent += "\n" + style;
	}
};