/* -*- Mode: javascript; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Calendar code.
 *
 * The Initial Developer of the Original Code is
 *   Joey Minta <jminta@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Matthew Willis <mattwillis@gmail.com>
 *   Ferdinand Grassmann <ferdinand@grassmann.info>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * Prints a rough month-grid of events/tasks
 */

var { Services } = ChromeUtils.import("resource://gre/modules/Services.jsm");
var { cal } = ChromeUtils.import("resource://calendar/modules/calUtils.jsm");
 
Components.utils.import("resource://calendar/modules/calUtils.jsm");
//Components.utils.import("resource://fgprinters/modules/calXMLUtils.jsm");
//Components.utils.import("resource://fgprinters/modules/calPrintUtils.jsm");
Components.utils.import("resource://fgprinters/modules/calHtmlUtils.jsm");
 
function FGcalYearPrinter() {
}

var FGcalYearPrinterID = Components.ID('{F0159b00-962F-11DD-AD8B-0800200C9A66}');
var FGcalYearPrinterInterfaces = [Components.interfaces.calIPrintFormatter];
var FGcalYearPrinterContractID = "@mozilla.org/calendar/printformatter;1?type=fgyear";
var FGcalYearPrinterDescription = "Calendar Year Print Formatter";

FGcalYearPrinter.prototype = {
	classID: FGcalYearPrinterID,
	QueryInterface: ChromeUtils.generateQI([Ci.calIPrintFormatter]),
	
	
	get name() {
        return "FG " + cal.l10n.getAnyString("fgprinters", "fgprinters", "yearview", []); 
    },

	formatToHtml : function FGyearPrint_format(aStream, aStart, aEnd, aCount, aItems, aTitle) {

		// Parse the template file
		let html = cal.xml.parseFile("chrome://fgprinters/skin/printing/empty.html");
		
		// Set page title
		html.getElementsByTagName("title")[0].textContent = aTitle;
		
		// Set the style sheet
		this.setupStyleSheet(html);
    
		let printtitle = Services.prefs.getBoolPref("fgprinters.printtitle", false);
		let subTitle = Services.prefs.getBoolPref("fgprinters.subtitle", "");
	
		let halfYear = Services.prefs.getBoolPref("fgprinters.year.halfyear", false);
		let horView = Services.prefs.getBoolPref("fgprinters.year.horizontal", false);
		let sepDayNames = Services.prefs.getBoolPref("fgprinters.year.seperatedaynames", true);
    
		let firstLetter = Services.prefs.getBoolPref("fgprinters.year.firstletter", false);
		let printWeekDays = Services.prefs.getBoolPref("fgprinters.year.weekdays", false);

		let fsize = Services.prefs.getIntPref("fgprinters.year.fontsize", 10);
		let dnStyle = 'font-size: ' + fsize + 'px;';

		// If aStart or aEnd weren't passed in, we need to calculate them based on
		// aItems data.

		let start = aStart;
		let end = aEnd;
		if (!start || !end) {
			for (let item of aItems) {
				let itemStart = item.startDate || item.entryDate;
				let itemEnd = item.endDate || item.dueDate;
				if (!start || (itemStart && start.compare(itemStart) == 1)) {
					start = itemStart;
				}
				if (!end || (itemEnd && end.compare(itemEnd) == -1)) {
					end = itemEnd;
				}
			}
		}
		// Play around with aStart and aEnd to determine the minimal number of
		// months we can show to still technically meet their requirements.  This
		// is most useful when someone printed 'Current View' in the month view. If
		// we take the aStart and aEnd literally, we'll print 3 months (because of
		// the extra days at the start/end), but we should avoid that.
		//
		// Basically, we check whether aStart falls in the same week as the start
		// of a month (ie aStart  is Jan 29, which often is in the same week as
		// Feb 1), and similarly whether aEnd falls in the same week as the end of
		// a month.
		let weekStart = Services.prefs.getIntPref("calendar.week.start", 0);
		maybeNewStart = start.clone();
		maybeNewStart.day = 1;
		maybeNewStart.month = start.month+1;
		try {
			maybeNewStart.normalize();
		} catch(ex) {}
	
		let date = start.clone();
		date.month = 0;
		try {
			date.normalize();
		} catch(ex) {}

		let realEnd = end.clone();
		realEnd.month = 11;
		try {
			realEnd.normalize();
		} catch(ex) {}

		let body = html.getElementsByTagName('body')[0];
		// Title and Subtitle
		if (printtitle && aTitle) {
			let p_aTitle = html.createElementNS("http://www.w3.org/1999/xhtml","p");
			p_aTitle.className = 'main-title';
			p_aTitle.textContent = aTitle;
			body.appendChild(p_aTitle);
		}
		if (subTitle) {
			let p_subTitle = html.createElementNS("http://www.w3.org/1999/xhtml","p");
			p_subTitle.className = 'sub-title';
			p_subTitle.textContent = subTitle;
			body.appendChild(p_subTitle);
		}

		let year = html.createElementNS("http://www.w3.org/1999/xhtml","table");// <table width='100%'/>;
		year.setAttribute('width', '100%');
		let allMonths = html.createElementNS("http://www.w3.org/1999/xhtml","tr");//<tr style='page-break-inside: avoid;' />;
		allMonths.setAttribute('style', 'page-break-inside: avoid;');
		let first = 2;

		while (date.compare(realEnd) < 0) {
			if (first) {
				if (first == 1) {
					year.appendChild(allMonths);
					allMonths = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
					allMonths.setAttribute('style', 'page-break-inside: avoid;');
				}
				if (first == 3) {
					year.appendChild(allMonths);
					allMonths = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
					allMonths.setAttribute('style', 'page-break-inside: avoid;');
				}
				if ((first == 1) || (first == 2)) {
					let head = html.createElementNS("http://www.w3.org/1999/xhtml","tr");// <tr/>;
					year.appendChild(head);
					
					let fsize = Services.prefs.getIntPref("fgprinters.year.fontsizetitle", 26);
					let tStyle = 'font-size: ' + fsize + 'px;';
					//head.appendChild(<td colspan="38" align="center" style={tStyle}>{date.year}</td>);
					let yearTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
					yearTD.setAttribute('colspan', '38');
					yearTD.setAttribute('align', 'center');
					yearTD.setAttribute('style', tStyle);
					yearTD.textContent = date.year;
					head.appendChild(yearTD);
					
					if (horView && sepDayNames && printWeekDays) {
						//<tr style='page-break-inside: avoid;' />;
						let daysTr = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
						daysTr.setAttribute('style', 'page-break-inside: avoid;');
						let tmpTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
						tmpTD.setAttribute('style', 'color: transparent;');
						tmpTD.textContent = 'A ';
						daysTr.appendChild(tmpTD);
						for (let i = 0; i < 37; i++) {
							let dayName = cal.l10n.getCalString("dateFormat", "day."+ (((i + weekStart) % 7)+1) + ".Mmm");
							if (firstLetter) {
								dayName = dayName[0];
							}
							let dayNameTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
							dayNameTD.setAttribute('style', dnStyle);
							dayNameTD.textContent = dayName;
							daysTr.appendChild(dayNameTD);
						}
						year.appendChild(daysTr);
					}
				}
				first = 0;
			}
	
			if (horView) {
				allMonths = this.createMonthTable(html, date);
			} else {
				let w ="8%";
				if (halfYear) {
					w = "16%";
				} 
				let thisMonth = html.createElementNS("http://www.w3.org/1999/xhtml","td"); //<td valign="top" width="8%"/>;
				thisMonth.setAttribute('valign', 'top');
				thisMonth.setAttribute('width', w);
				thisMonth.appendChild(this.createMonthTable(html, date));
				allMonths.appendChild(thisMonth);
			}
			date.month++;
			try {
				date.normalize();
			} catch(ex) {
			}
			if (date.month == 0) {
				first = 1;
			}
			if ((date.month == 6) && halfYear) {
				first = 3;
			}
			if (horView) {
				first = 3;
			}
		}
		year.appendChild(allMonths);
		body.appendChild(year);
		
		// Stream out the resulting HTML
		let htmlString = cal.xml.serializeDOM(html);		
		//Components.utils.reportError(htmlString);
		let convStream = Components.classes["@mozilla.org/intl/converter-output-stream;1"]
                                   .createInstance(Components.interfaces.nsIConverterOutputStream);
		convStream.init(aStream, 'UTF-8', 0, 0x0000);
		convStream.writeString(htmlString);
	},

	createMonthTable : function FGyearPrint_doOtherMonth(document, aMonth) {
		let weekStart = Services.prefs.getIntPref("calendar.week.start", 0);
		
		//let monthName = cal.l10n.getCalString("dateFormat", "month." + (aMonth.month +1)+ ".name"); // + " " + aMonth.year;
		let monthName = cal.l10n.formatMonth(aMonth.month + 1, "calendar", "monthInYear");
		
		
		
		let fsize = Services.prefs.getIntPref("fgprinters.year.fontsize", 10);
		let tStyle = 'font-size: ' + fsize + 'px;';
		let fsizem = Services.prefs.getIntPref("fgprinters.year.fontsizemonth", 16);
		let mStyle = 'font-size: ' + fsizem + 'px;';
		let firstLetter = Services.prefs.getBoolPref("fgprinters.year.firstletter", false);
		let printWeekDays = Services.prefs.getBoolPref("fgprinters.year.weekdays", false);
		let alignDays = Services.prefs.getBoolPref("fgprinters.year.aligndays", false);
		let horView = Services.prefs.getBoolPref("fgprinters.year.horizontal", false);
		let sepDayNames = Services.prefs.getBoolPref("fgprinters.year.seperatedaynames", true);
	
		let monthTable;
		if (horView) {
			//<tr style={tStyle}><td align='center' width='0%' style={mStyle}>{monthName}</td></tr>;
			monthTable = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
			monthTable.setAttribute('style', tStyle);
			let monthNameTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			monthTable.appendChild(monthNameTD);
			monthNameTD.setAttribute('align', 'center');
			monthNameTD.setAttribute('width', '0%');
			monthTable.setAttribute('style', mStyle);
			monthNameTD.textContent = monthName;
		} else {
			// <table width='100%' rules='both' style={tStyle}><tr><td align='center' style={mStyle}>{monthName}</td></tr></table>;
			monthTable = document.createElementNS("http://www.w3.org/1999/xhtml","table");
			monthTable.setAttribute('style', tStyle);
			monthTable.setAttribute('width', '100%');
			monthTable.setAttribute('rules', 'both');
			let tmpTR = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
			monthTable.appendChild(tmpTR);
			let monthNameTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpTR.appendChild(monthNameTD);
			monthNameTD.setAttribute('align', 'center');
			monthTable.setAttribute('style', mStyle);
			monthNameTD.textContent = monthName;
		}
	
		let firstDate = aMonth.startOfMonth.clone();
	
		let lastDate = aMonth.endOfMonth.clone();
		firstDate.isDate = true;
		lastDate.isDate = true;
	
		let nameStyle = "width: "+fsize*3+"px; float: left; text-align: left;";
	
		let date = firstDate.clone();
		let itemListIndex = 0;
		let weekRow = document.createElementNS("http://www.w3.org/1999/xhtml","tr"); //<tr/>;
		const weekPrefix = "calendar.week.";
		let prefNames = ["d0sundaysoff", "d1mondaysoff", "d2tuesdaysoff",
						"d3wednesdaysoff", "d4thursdaysoff", "d5fridaysoff", "d6saturdaysoff"];
		let defaults = [true, false, false, false, false, false, true];
		let daysOff = new Array();
		for (let i in prefNames) {
			if (Services.prefs.getCharPref(weekPrefix+prefNames[i], defaults[i])) {
				daysOff.push(Number(i));
			}
		}
	
		if (horView) {
			if ((alignDays) || ((sepDayNames) && (printWeekDays))) {
				let startWeekday = date.weekday;
				if (startWeekday < weekStart) {
					startWeekday += 7;
				}
				for (let i = weekStart; i < startWeekday; i++) {
					//<td width='3%' style='border: 1px solid transparent; vertical-align: center; color: transparent;'>A </td>;
					let fakeday = document.createElementNS("http://www.w3.org/1999/xhtml","td");
					fakeday.setAttribute('width', '3%');
					fakeday.setAttribute('style', 'border: 1px solid transparent; vertical-align: center; color: transparent;');
					fakeday.textContent = 'A ';
					monthTable.appendChild(fakeday);
				}
			}
			while (date.compare(lastDate) != 1) {
				let myClass = 'day-box';
				if (daysOff.some(function(a) { return a == date.weekday; })) {
					myClass += ' day-off';
				}
				let day = null;
				if ((printWeekDays) && !(sepDayNames)) {
					let dayName = cal.l10n.getCalString("dateFormat", "day."+ (date.weekday + 1) + ".Mmm");
					if (firstLetter) {
						dayName = dayName[0];
					}
					//<td width='3%' class={myClass} style='text-align: right; vertical-align: center;'><div style={nameStyle}>{dayName}</div> {date.day}</td>;
					day = document.createElementNS("http://www.w3.org/1999/xhtml","td");
					day.className = myClass;
					day.setAttribute('width', '3%');
					day.setAttribute('style', 'text-align: right; vertical-align: center;');
					
					let tmpDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
					tmpDiv.setAttribute('style', nameStyle);
					tmpDiv.textContent = dayName;
					day.appendChild(tmpDiv);
					day.textContent += date.day;
				} else {	
					//<td width='3%' class={myClass} style='text-align: left; vertical-align: center;'>{date.day}</td>;
					day = document.createElementNS("http://www.w3.org/1999/xhtml","td");
					day.className = myClass;
					day.setAttribute('width', '3%');
					day.setAttribute('style', 'text-align: left; vertical-align: center;');
					day.textContent = date.day;
				}
				monthTable.appendChild(day);
				date.day++;
				try {
					date.normalize();
				} catch(ex) {
				}
			}
		} else {
			let monthCol = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			if (alignDays) {
				let startWeekday = date.weekday;
				if (startWeekday < weekStart) {
					startWeekday += 7;
				}
				for (let i = weekStart; i < startWeekday; i++) {
					//<div style='border: 1px solid transparent; vertical-align: top; color: transparent;'>A </div>;
					let fakeday = document.createElementNS("http://www.w3.org/1999/xhtml","div");
					fakeday.setAttribute('style', 'border: 1px solid transparent; vertical-align: top; color: transparent;');
					fakeday.textContent = 'A ';
					monthCol.appendChild(fakeday);
				}
			}
			while (date.compare(lastDate) != 1) {
				let myClass = 'day-box';
				if (daysOff.some(function(a) { return a == date.weekday; })) {
					myClass += ' day-off';
				}
				let day = null;
				if (printWeekDays) {
					let dayName = cal.l10n.getCalString("dateFormat", "day."+ (date.weekday + 1) + ".Mmm");
					if (firstLetter) {
						dayName = dayName[0];
					}
					//<div class={myClass} style='text-align: right;'><div style={nameStyle}>{dayName}</div> {date.day}</div>;
					day = document.createElementNS("http://www.w3.org/1999/xhtml","div");
					day.className = myClass;
					day.setAttribute('style', 'text-align: right;');
					let tmpDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
					tmpdiv.setAttribute('style', nameStyle);
					tmpDiv.textContent = dayName;
					day.appendChild(tmpDiv);
					day.textContent += date.day;
				} else {
					//<div class={myClass} style='text-align: left;'>{date.day}</div>;
					day = document.createElementNS("http://www.w3.org/1999/xhtml","div");
					day.className = myClass;
					day.setAttribute('style', 'text-align: left;');
					day.textContent = date.day;
				}
				monthCol.appendChild(day);
				date.day++;
				try {
					date.normalize();
				} catch(ex) {
				}
			}
			weekRow.appendChild(monthCol);
			monthTable.appendChild(weekRow);
		}
		return monthTable;
	},


	setupStyleSheet: function FGlist_setupStyleSheet(html) {
		let fontsizetitle = Services.prefs.getIntPref("fgprinters.year.fontsizetitle", 26);
		let fsizeglobaltitle = Services.prefs.getIntPref("fgprinters.fontsizetitle", 26);
		let fsizesubtitle = Services.prefs.getIntPref("fgprinters.fontsizesubtitle", 20);
		let wec = Services.prefs.getCharPref("fgprinters.weekendcolour", "#FFFFEE");	
		let sansserif = Services.prefs.getBoolPref("fgprinters.sansserif", true);
	
		let style = ".main-table { font-size: "+fontsizetitle+"px; font-weight: bold; }\n";
		style += ".main-title { font-size: "+fsizeglobaltitle+"px; font-weight:bold; text-align: center; }\n";
		style += ".sub-title { font-size: "+fsizesubtitle+"px; font-weight:bold; text-align: center; }\n";
		style += ".day-box { border: 1px solid black; vertical-align: top; }\n";
		style += ".day-box-sun { border-top: 1px solid black; vertical-align: top; }\n";
		style += ".day-off { background-color: "+wec+" !important; }\n";
		if (sansserif) { style += "body, table, tr, td, p { font-family: Arial, sans-serif; }\n"; }
   		html.getElementsByTagName('style')[0].textContent += "\n" + style;
	}

}

function log(what) {
    let consoleSvc = Components.classes["@mozilla.org/consoleservice;1"].
                     getService(Components.interfaces.nsIConsoleService);
    consoleSvc.logStringMessage(what);    
}

function getContrastingTextColor(bgColor) {
    let calcColor = bgColor.replace(/#/g, "");
    let red = parseInt(calcColor.substring(0, 2), 16);
    let green = parseInt(calcColor.substring(2, 4), 16);
    let blue = parseInt(calcColor.substring(4, 6), 16);

    // Calculate the L(ightness) value of the HSL color system.
    // L = (max(R, G, B) + min(R, G, B)) / 2
    let max = Math.max(Math.max(red, green), blue);
    let min = Math.min(Math.min(red, green), blue);
    let lightness = (max + min) / 2;

    // Consider all colors with less than 50% Lightness as dark colors
    // and use white as the foreground color; otherwise use black.
    // Actually we use a threshold a bit below 50%, so colors like
    // #FF0000, #00FF00 and #0000FF still get black text which looked
    // better when we tested this.
    if (lightness < 120) {
        return "white";
    }
    return "black";
}
