/* -*- Mode: javascript; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Calendar code.
 *
 * The Initial Developer of the Original Code is
 *  Michiel van Leeuwen <mvl@exedo.nl>
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var { Services } = ChromeUtils.import("resource://gre/modules/Services.jsm");
var { cal } = ChromeUtils.import("resource://calendar/modules/calUtils.jsm");
 
//Components.utils.import("resource://fgprinters/modules/calUtils.jsm");
Components.utils.import("resource://calendar/modules/calUtils.jsm");
//Components.utils.import("resource://fgprinters/modules/calXMLUtils.jsm");
//Components.utils.import("resource://fgprinters/modules/calPrintUtils.jsm");
Components.utils.import("resource://fgprinters/modules/calHtmlUtils.jsm");
 
/**
 * A thin wrapper that is a print formatter, and just calls the html (list) 
 * exporter
 */
function FGcalListPrinter() {
}

var FGcalListPrinterID = Components.ID('{96203FEE-C739-11DC-B964-7BED55D89593}');
var FGcalListPrinterInterfaces = [Components.interfaces.calIPrintFormatter];
var FGcalListPrinterContractID = "@mozilla.org/calendar/printformatter;1?type=fglist";
var FGcalListPrinterDescription = "Calendar List Print Formatter";

FGcalListPrinter.prototype = {
	classID: FGcalListPrinterID,
	QueryInterface: ChromeUtils.generateQI([Ci.calIPrintFormatter]),
	
	
	get name() {
        return "FG " + cal.l10n.getAnyString("fgprinters", "fgprinters", "listview", []); 
    },
	
	/**
	 *
	 *
	 *
	 *
	 */
	formatToHtml: function FGlistPrint_format(aStream, aStart, aEnd, aCount, aItems, aTitle) {
		
		// Parse the template file
		let html = cal.xml.parseFile("chrome://fgprinters/skin/printing/empty.html");
	
		// Set page title
		html.getElementsByTagName("title")[0].textContent = aTitle;
	
		// Set the style sheet
		this.setupStyleSheet(html);
    
		let printLocation = Services.prefs.getBoolPref("fgprinters.list.printlocation", true);
		let printDescription = Services.prefs.getBoolPref("fgprinters.list.printdescription", true); 
		let printCategory = Services.prefs.getBoolPref("fgprinters.list.printcategory", true);
		let printHeader = Services.prefs.getBoolPref("fgprinters.list.printheader", true);
		let printStatus = Services.prefs.getBoolPref("fgprinters.list.printstatus", true);
		let printCalname = Services.prefs.getBoolPref("fgprinters.list.printcalname", false);
		let printMonths = Services.prefs.getBoolPref("fgprinters.list.printmonths", false);
	
		// NEW : print participants
		let printOrganizer = Services.prefs.getBoolPref("fgprinters.list.printorganizer", false);
		let printReqAttendees = Services.prefs.getBoolPref("fgprinters.list.printreqattendees", false);
		let printOptAttendees = Services.prefs.getBoolPref("fgprinters.list.printoptattendees", false);
		let printFyiAttendees = Services.prefs.getBoolPref("fgprinters.list.printfyiattendees", false);	
    
		let body = html.getElementsByTagName('body')[0];

		// Title and Subtitle
		let printtitle = Services.prefs.getBoolPref("fgprinters.printtitle", false);
		let subTitle = Services.prefs.getCharPref("fgprinters.subtitle", "");
		if (printtitle && aTitle) {
			let p_aTitle = html.createElementNS("http://www.w3.org/1999/xhtml","p");
			p_aTitle.className = 'main-title';
			p_aTitle.textContent = aTitle;
			body.appendChild(p_aTitle);
		}
		if (subTitle) {
			let p_subTitle = html.createElementNS("http://www.w3.org/1999/xhtml","p");
			p_subTitle.className = 'sub-title';
			p_subTitle.textContent = subTitle;
			body.appendChild(p_subTitle);
		}

		// helper: returns the passed item's startDate, entryDate or dueDate, in
		//         that order. If the item doesn't have one of those dates, this
		//         doesn't return.
		function hasUsableDate(item) {
			return item.startDate || item.entryDate || item.dueDate;
		}

		// Clean out the item list so it only contains items we will want to
		// include in the printout.
		let filteredItems = aItems.filter(hasUsableDate);
		var calIEvent = Components.interfaces.calIEvent;
		var calITodo = Components.interfaces.calITodo
		function calGetStartDate(aItem){
			return (isEvent(aItem) ? aItem.startDate : aItem.entryDate);
		}
		function isEvent(aObject) {
			return aObject instanceof Components.interfaces.calIEvent;
		} 
		function compareItems(a, b) {
			var start_a = calGetStartDate(a);
			if (!start_a) {
				return -1;
			}
			var start_b = calGetStartDate(b);
			if (!start_b) {
				return 1;
			}
			return start_a.compare(start_b);
		}
		let sortedList = filteredItems.sort(compareItems);
		

	
		// A place to cache the string for "All Day" events later if we need item.
		let mAllDayString = null;
    
		// Start at the beginning of the week that aStart is in, and loop until
		// we're at aEnd. In the loop we build the HTML table for each day, and
		// get the day's items using getDay().
		let start = aStart || sortedList[0].startDate || sortedList[0].entryDate || sortList[0].dueDate;
		cal.ASSERT(start, "can't find a good starting date to print");

		let lastItem = sortedList[sortedList.length-1];
		let end = aEnd || lastItem.startDate || lastItem.entryDate || lastItem.dueDate;
		cal.ASSERT(end, "can't find a good ending date to print");

		let date = start.clone();
		if (!date.isDate) {
			date.isDate = 1;
		} 
    
		let endDate = end.clone();
		if (!endDate.isDate) {
			endDate.isDate = 1;
			endDate.day += 1;
		}

		if (printMonths) {
			let prevMonth = date.clone();
			prevMonth.month--;
			prevMonth.day = 15;
			try { prevMonth.normalize(); } catch(ex) {}
			let thisMonth = date.clone();
			let nextMonth = date.clone();
			nextMonth.month++;
			nextMonth.day = 15;
			try {nextMonth.normalize();} catch(ex) {}
			let prevMonthTable = this.createMonthTable(html, prevMonth);
			let thisMonthTable = this.createMonthTable(html, thisMonth);
			let nextMonthTable = this.createMonthTable(html, nextMonth);
		 
			// <table border='0' width='100%' class='main-table'>
			let minimonthTable = html.createElementNS("http://www.w3.org/1999/xhtml","table");
			minimonthTable.setAttribute('border', '0');
			minimonthTable.setAttribute('width', '100%');
			minimonthTable.className = 'main-table';
			
			let tmpTR = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
			minimonthTable.appendChild(tmpTR);
		 
			// <td width='1%' align='left' valign='center'>{prevMonthTable}</td>
			let prevMonthTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			prevMonthTD.setAttribute('width', '1%');
			prevMonthTD.setAttribute('align', 'left');
			prevMonthTD.setAttribute('valign', 'center');
			prevMonthTD.appendChild(prevMonthTable);
			tmpTR.appendChild(prevMonthTD);
		 
			// <td width='49%' align='center' valign='center'><div style='color: transparent;'>a</div></td>
			let spacerTD1 = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			spacerTD1.setAttribute('width','49%');
			spacerTD1.setAttribute('align','center');
			spacerTD1.setAttribute('valign','center');
			let tmpDiv1 = html.createElementNS("http://www.w3.org/1999/xhtml","div");
			tmpDiv1.setAttribute('style', 'color: transparent;');
			tmpDiv1.textContent = 'a';
			spacerTD1.appendChild(tmpDiv1);
			tmpTR.appendChild(spacerTD1);
		 
			let thisMonthTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			thisMonthTD.setAttribute('width','1%');
			thisMonthTD.setAttribute('align','center');
			thisMonthTD.setAttribute('valign','center');
			thisMonthTD.appendChild(thisMonthTable);
			tmpTR.appendChild(thisMonthTD);
		 
			// <td width='48%' align='center' valign='center'><div style='color: transparent;'>a</div></td>
			let spacerTD2 = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			spacerTD2.setAttribute('width','48%');
			spacerTD2.setAttribute('align','center');
			spacerTD2.setAttribute('valign','center');
			let tmpDiv2 = html.createElementNS("http://www.w3.org/1999/xhtml","div");
			tmpDiv2.setAttribute('style', 'color: transparent;');
			tmpDiv2.textContent = 'a';
			spacerTD2.appendChild(tmpDiv2);
			tmpTR.appendChild(spacerTD2);
		 
			// <td width='1%' align='right' valign='center'>{nextMonthTable}</td>
			let nextMonthTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			nextMonthTD.setAttribute('width','1%');
			nextMonthTD.setAttribute('align','right');
			nextMonthTD.setAttribute('valign','center');
			nextMonthTD.appendChild(nextMonthTable);
			tmpTR.appendChild(nextMonthTD);
		 
			body.appendChild(minimonthTable);
		} 

		const weekPrefix = "calendar.week.";
		let prefNames = ["d0sundaysoff", "d1mondaysoff", "d2tuesdaysoff",
                     "d3wednesdaysoff", "d4thursdaysoff", "d5fridaysoff", "d6saturdaysoff"];
		let defaults = [true, false, false, false, false, false, true];

	
		// <table width='100%' border='1' rules='rows' cellpadding='5' style='border: solid 1px black; border-collapse:collapse;'/>;
		let mainTable = html.createElementNS("http://www.w3.org/1999/xhtml","table");
		mainTable.setAttribute('width','100%');
		mainTable.setAttribute('border','1');
		mainTable.setAttribute('rules','rows');
		mainTable.setAttribute('cellpadding','5');
		mainTable.setAttribute('style','border: solid 1px black; border-collapse:collapse;');

		let dateFormatter = Components.classes["@mozilla.org/calendar/datetime-formatter;1"]
                                  .getService(Components.interfaces.calIDateTimeFormatter);

		if (printHeader) {
			let sbs = Components.classes["@mozilla.org/intl/stringbundle;1"]
	                    .getService(Components.interfaces.nsIStringBundleService);
			let props = sbs.createBundle("chrome://fgprinters/locale/fgprinters.properties");
			let cat = props.GetStringFromName("category");
			let stEn = props.GetStringFromName("startEnd");
			let event = props.GetStringFromName("event");
			let descr = props.GetStringFromName("description");
			let loc = props.GetStringFromName("location");
			let stat = props.GetStringFromName("status");
			let can = props.GetStringFromName("cal");
		
			let org = props.GetStringFromName("org");
			let reqAtts = props.GetStringFromName("reqattendees");
			let optAtts = props.GetStringFromName("optattendees");
			let fyiAtts = props.GetStringFromName("fyiattendees");
		
			if (!printCategory) {
				cat = " ";
			} 
		
			if (!printLocation) {
				loc = " ";
			}
			if (!printDescription) {
				descr = " ";
			}

			if (!printStatus) {
				stat = " ";
			} 
			if (!printCalname) {
				can = " ";
			}
		
			// ADDED participants
			if(!printOrganizer) {
				org =  " ";
			}
			if(! printReqAttendees) {
				reqAtts = " ";
			}
			if(! printOptAttendees) {
				optAtts = " ";
			}
			if(! printFyiAttendees) {
				fyiAtts = " ";
			}
		
			let fsizeh = Services.prefs.getIntPref("fgprinters.list.fontsizeheader", 14);
			let style = 'font-size: '+fsizeh+'px; color: black; font-weight:bold;';
		
			let colsCount=12;
			if(!printStatus) {
				colsCount=10;
			} 
		
			if (printCalname) {
				let calname = " ";
				if(aItems) {
					let firstEvt = aItems[0];
					calname = props.GetStringFromName("cal") + ": " + firstEvt.calendar.getProperty('name');
				}
				// mainTable.appendChild(<tr style={style}><td class="header" colspan={colsCount}>{calname}</td></tr>);
				let tmpTR = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
				tmpTR.setAttribute('style', style);
				let tmpTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
				tmpTD.className = 'header';
				tmpTD.setAttribute('colspan', colsCount);
				tmpTD.textContent = calname;
				tmpTR.appendChild(tmpTD);
				mainTable.appendChild(tmpTR);
			}
		
			let tdClass = 'bordered';
			let tmpTR = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
			tmpTR.setAttribute('style', style);
			mainTable.appendChild(tmpTR);
			if(printStatus) {
				tdClass += ' header';
				let tmpTD1 = html.createElementNS("http://www.w3.org/1999/xhtml","td");
				tmpTD1.textContent = ' ';
				tmpTR.appendChild(tmpTD1);

				let tmpCat = html.createElementNS("http://www.w3.org/1999/xhtml","td");
				tmpCat.textContent = cat;
				tmpTR.appendChild(tmpCat);
			
				let tmpStat = html.createElementNS("http://www.w3.org/1999/xhtml","td");
				tmpStat.textContent = stat;
				tmpTR.appendChild(tmpStat);
			}
			//<td class='bordered'>{stEn}</td>
			let tmpStEn = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpStEn.className = tdClass;
			tmpStEn.textContent = stEn;
			tmpTR.appendChild(tmpStEn);
			
			//<td class='bordered'>{event}</td>
			let tmpEvent = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpEvent.className = tdClass;
			tmpEvent.textContent = event;
			tmpTR.appendChild(tmpEvent);
		
			//<td class='bordered' width="30%">{descr}</td>
			let tmpDescr = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpDescr.className = tdClass;
			tmpDescr.setAttribute('width', '30%');
			tmpDescr.textContent = descr;
			tmpTR.appendChild(tmpDescr);
		
			// <td class='bordered'>{loc}</td>
			let tmpLoc = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpLoc.className = tdClass;
			tmpLoc.textContent = loc;
			tmpTR.appendChild(tmpLoc);
		
			//<td class='bordered'>{org}</td>
			let tmpOrg = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpOrg.className = tdClass;
			tmpOrg.textContent = org;
			tmpTR.appendChild(tmpOrg);
		
			// <td class='bordered'>{reqAtts}</td>
			let tmpReqAtts = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpReqAtts.className = tdClass;
			tmpReqAtts.textContent = reqAtts;
			tmpTR.appendChild(tmpReqAtts);
		
			//<td class='bordered'>{optAtts}</td>
			let tmpOptAtts = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpOptAtts.className = tdClass;
			tmpOptAtts.textContent = optAtts;
			tmpTR.appendChild(tmpOptAtts);
			
			// <td class='bordered'>{fyiAtts}</td></tr>);
			let tmpFyiAtts = html.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpFyiAtts.className = tdClass;
			tmpFyiAtts.textContent = fyiAtts;
			tmpTR.appendChild(tmpFyiAtts);		
		}
		
		let defaultTimezone = null;
		try {
			defaultTimezone = cal.dtz.defaultTimezone; 
		} catch(ex) {}
    
		while(date.compare(endDate) == -1) {
			let isOff = Services.prefs.getCharPref(weekPrefix+prefNames[date.weekday], defaults[date.weekday]);
				
			let oneDay = this.getDay(html, date, sortedList, isOff);
			
			//Components.utils.reportError("DAY: "+date+ '='+oneDay);
			
			if (oneDay) {
				let dateString = null;
				try {
					dateString = dateFormatter.formatDateLong(date.getInTimezone(defaultTimezone));
				} catch(ex) {
					dateString = dateFormatter.formatDateLong(date);
				}
				let tmpDayTR = html.createElementNS("http://www.w3.org/1999/xhtml","tr");
				tmpDayTR.setAttribute('style', 'page-break-after: avoid;');
				mainTable.appendChild(tmpDayTR);
			
				let tmpDayTD = html.createElementNS("http://www.w3.org/1999/xhtml","td");
				tmpDayTD.setAttribute('colspan', '13');
				tmpDayTD.setAttribute('align', 'center');
				tmpDayTD.className = 'day-name';
				tmpDayTD.textContent = dateString;
				tmpDayTR.appendChild(tmpDayTD);

				mainTable.appendChild(oneDay);
			}
			date.day += 1;
			try {
				date.normalize();
			} catch(ex) {}
		}
    
		body.appendChild(mainTable);
		// Stream out the resulting HTML
		let htmlString = cal.xml.serializeDOM(html);		
		//Components.utils.reportError(htmlString);
		let convStream = Components.classes["@mozilla.org/intl/converter-output-stream;1"]
                                   .createInstance(Components.interfaces.nsIConverterOutputStream);
		convStream.init(aStream, 'UTF-8', 0, 0x0000);
		convStream.writeString(htmlString);
	},

	/**
	 * Given a calIDateTime and an array of items, this function creates an HTML
	 * table containing the items, using the appropriate formatting and colours.
	 */
    getDay : function FGlistPrint_getDayTable(document, aDate, aItems, isOff) {
    // mainTd is the <td> element from the parent HTML table that will hold
    // the child HTML tables containing the date string and this day's items.
	let nofEvents = 0;

    let mainTd = document.createElementNS("http://www.w3.org/1999/xhtml","div"); //<div/>;
    let dateFormatter = Components.classes["@mozilla.org/calendar/datetime-formatter;1"]
                                  .getService(Components.interfaces.calIDateTimeFormatter);

    let printAllDay = Services.prefs.getBoolPref("fgprinters.list.printallday", false);
    let printLocation = Services.prefs.getBoolPref("fgprinters.list.printlocation", true);
    let printDescription = Services.prefs.getBoolPref("fgprinters.list.printdescription", true); 
    let printCategory = Services.prefs.getBoolPref("fgprinters.list.printcategory", true);
    let printCalColor = Services.prefs.getBoolPref("fgprinters.list.printcalcolor", true);
    let printStatus = Services.prefs.getBoolPref("fgprinters.list.printstatus", true);
    let printPriority = Services.prefs.getBoolPref("fgprinters.list.printpriority", true);
	let printCalname = Services.prefs.getBoolPref("fgprinters.list.printcalname", false);
	// ADDED : print participants
	let printOrganizer = Services.prefs.getBoolPref("fgprinters.list.printorganizer", false);
	let printReqAttendees = Services.prefs.getBoolPref("fgprinters.list.printreqattendees", false);
	let printOptAttendees = Services.prefs.getBoolPref("fgprinters.list.printoptattendees", false);
	let printFyiAttendees = Services.prefs.getBoolPref("fgprinters.list.printfyiattendees", false);
	
    let fsize = Services.prefs.getIntPref("fgprinters.list.fontsize", 14);
    let obeyPrivacy = Services.prefs.getBoolPref("fgprinters.obeyprivacy", false);
    let defaultTimezone = null;
	try {
		defaultTimezone = cal.dtz.defaultTimezone; 
	} catch(ex) {}
	
    // Add the formatted items (in their child HTML table)
    for (let item of aItems) {
        //Components.utils.reportError('Event' + item.title);
		let sDate = item.startDate || item.entryDate || item.dueDate;
        let eDate = item.endDate || item.dueDate || item.entryDate;
        if (defaultTimezone && sDate) {
			try {
				sDate = sDate.getInTimezone(defaultTimezone);
			} catch(ex) {}
        }
        if (defaultTimezone && eDate) {
            try {
				eDate = eDate.getInTimezone(defaultTimezone);
			} catch(ex) {}
        }
        
        // End dates are exclusive. Adjust the eDate accordingly.
        if (sDate && sDate.isDate && eDate) {
            eDate = eDate.clone();
            eDate.day -= 1;
            try {
                eDate.normalize();
            } catch(ex) {}
        }

        // If the item has no end date, or if the item's end date is aDate or
        // is before aDate, skip to the next item.
        if (!eDate || (eDate.compare(aDate) < 0)) {
            continue;
        }
       
        // No start date or a start date that's after the date we want is bad.
        if (!sDate || (sDate.compare(aDate) > 0)) {
            break;
        }

        function getStringForDate(oneDate) {
            if (!oneDate.isDate) {
                return dateFormatter.formatTime(oneDate);
            }

            // We cache the string for "All Day" 'cause we're good like that.
            if (this.mAllDayString == null) {
                let sbs = Components.classes["@mozilla.org/intl/stringbundle;1"]
                                    .getService(Components.interfaces.nsIStringBundleService);
                let props = sbs.createBundle("chrome://calendar/locale/dateFormat.properties");
                this.mAllDayString = props.GetStringFromName("AllDay");
            }
            if (printAllDay) {
				return this.mAllDayString;
			} else { 
				return "";
			}
        }
	    //Components.utils.reportError('Event++');
		nofEvents++;

        let time;
        if (sDate && eDate) {
            if (!sDate.isDate) {
				let startTime = "";
				let endTime = "";
				if (sDate.compare(aDate) < 0) {
					let dummyDate = sDate.clone();
					dummyDate.hour = 0;
					dummyDate.minute = 0;
					try {
						dummyDate.normalize();
					} catch(ex) {
					}
					startTime = getStringForDate(dummyDate);
				} else {
					startTime = getStringForDate(sDate);
				}
				if (eDate.compare(aDate) > 0) {
					let dummyDate = eDate.clone();
					dummyDate.hour = 23;
					dummyDate.minute = 59;
					try {
						dummyDate.normalize();
					} catch(ex) {
					}
					endTime = getStringForDate(dummyDate);
				} else {
					endTime = getStringForDate(eDate);
				}
                time = startTime + '-' + endTime;
            } else {
                time = getStringForDate(sDate);
            }
        } else if (sDate) {
            time = getStringForDate(sDate);
        } else if (eDate) {
            time = getStringForDate(eDate);
        }

        let cat = item.getProperty("CATEGORIES");
        
        if (!cat) {
            cat = " ";
            for (let catT of item.getCategories({})) {
                try {
                    cat = catT;
                    break; // take first matching
                } catch(ex) {
                    cat = " ";
                }
            }
        }
        if (!printCategory) {
            cat = " ";
        }

		let style = 'font-size: '+fsize+'px; page-break-inside: avoid; color: black;';
		
		if (printCalColor) {
            let calColor = null;
			try {
				calColor = item.calendar.getProperty('color');
			} catch(ex) {
				let calMgr = Components.classes["@mozilla.org/calendar/manager;1"]
									.getService(Components.interfaces.calICalendarManager);
				calColor = calMgr.getCalendarPref(item.calendar, 'color'); 
			}
			style += 'border: solid ' + calColor + ' 2px;';
		}
        let location = " ";
        let descr = " ";
		let can = " ";

        if (printLocation) {
            if (item.hasProperty('LOCATION')) {
                location = item.getProperty('LOCATION');
            }
        }
        if (printDescription) {
            if (item.hasProperty('DESCRIPTION')) {
                descr = item.getProperty('DESCRIPTION');
				//Components.utils.reportError(descr);
            }
        }
		if (printCalname) {
			can = item.calendar.getProperty('name');
		}

        let title = item.title;
        if (obeyPrivacy && (item.privacy == "PRIVATE" || item.privacy == "CONFIDENTIAL")) { // TODO put private/condifential in title
            title = " ";
            descr = " ";
            location = " ";
        }
		//Components.utils.reportError(descr + '-' + title + '-' + item.privacy);
        let trClass = "normal";
        if (isOff) {
			trClass = "weekend";
		}
		let status = " ";
		if (item.status && printStatus) {
			if (item.status == "CONFIRMED") {
				status = cal.calGetString("calendar", "statusConfirmed");
			}
			if (item.status == "TENTATIVE") {
				status = cal.calGetString("calendar", "statusTentative");
			}
			if (item.status == "CANCELLED") {
				status = cal.calGetString("calendar", "statusCancelled");
			}
		}
		let prioCol = "transparent";
		if (item.priority && printPriority) {
			if (item.priority > 5) {
				prioCol = "#0F0";
			}
			if (item.priority == 5) {
				prioCol = "#FF0";
			}
			if (item.priority < 5) {
				prioCol = "#F00";
			}
		}
		let prioMarker = 'background-color: ' + prioCol + ';';
		
		
		// ADDED Organizer :
		let org = " ";
		let orgClass = 'bordered';
		if(printOrganizer) {
			try {
				org = item.organizer.commonName;
				if((!org) || (org == 'null')) {
					org = "-";
				}
			} catch(e){}
		} else {
			orgClass = '';
		}
		// ADDED attendees :
		
		// role= REQ-PARTICIPANT
		let reqAtts = " ";
		let reqClass='bordered';
		if(printReqAttendees) {
			try {
				for (let att of item.getAttendees({})) {
					if(att.role != 'REQ-PARTICIPANT') continue;
					if(reqAtts != " "){
						reqAtts += ", ";
					}
					
					let attName = att.commonName;
					if((!attName) || (attName == 'null')) {
						attName = att.id;
					}
					
					reqAtts += attName;
				}
			} catch(e){}
		} else {
			reqClass = '';
		}
		// role=OPT-PARTICIPANT
		let optAtts = " ";
		let optClass = 'bordered';
		if(printOptAttendees) {
			try {
				for (let att of item.getAttendees({})) {
					if(att.role != 'OPT-PARTICIPANT') continue;
					if(optAtts != " "){
						optAtts += ", ";
					}
					
					let attName = att.commonName;
					if((!attName) || (attName == 'null')) {
						attName = att.id;
					}
					
					optAtts += attName;
				}
			} catch(e){}
		} else {
		  optClass = '';
		}
		// role=NON-PARTICIPANT
		let fyiAtts = " ";
		let fyiClass = 'bordered';
		if(printFyiAttendees) {
			try {
				for (let att of item.getAttendees({})) {
					if(att.role != 'NON-PARTICIPANT') continue;
					if(fyiAtts != " "){
						fyiAtts += ", ";
					}
					
					let attName = att.commonName;
					if((!attName) || (attName == 'null')) {
						attName = att.id;
					}
					
					fyiAtts += attName;
				}
			} catch(e){}
		} else {
			fyiClass = '';
		}
		// let item = <tr width='100%' class={trClass} style={style}>
		let trItem = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
		trItem.setAttribute('width', '100%');
		trItem.setAttribute('style', style);
		trItem.className = trClass;
		if (printStatus) {
			// <td style={prioMarker}> </td>
			let tmpPrioMarkerTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpPrioMarkerTD.setAttribute('style', prioMarker);
			tmpPrioMarkerTD.textContent = ' ';
			trItem.appendChild(tmpPrioMarkerTD);
			// <td>{cat}</td>
			let tmpCatTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpCatTD.textContent = cat;
			trItem.appendChild(tmpCatTD);
			// <td>{status}</td>
			let tmpStatusTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			tmpStatusTD.textContent = status;
			trItem.appendChild(tmpStatusTD);
		}					   
	
	    //<td class='bordered'>{time}</td>
		let tmpTimeTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpTimeTD.className = 'bordered';
		tmpTimeTD.textContent = time;
		trItem.appendChild(tmpTimeTD);
		
		// <td class='bordered'>{title}</td>
		let tmpTitleTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpTitleTD.className = 'bordered';
		tmpTitleTD.textContent = title;
		trItem.appendChild(tmpTitleTD);
					   
		//<td class='bordered'>{descr}</td>
		//Components.utils.reportError(descr);
		let tmpDescrTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpDescrTD.className = 'bordered';
		tmpDescrTD.textContent = descr;
		trItem.appendChild(tmpDescrTD);
		
		// <td class='bordered'>{location}</td>
		let tmpLocationTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpLocationTD.className = 'bordered';
		tmpLocationTD.textContent = location;
		trItem.appendChild(tmpLocationTD);
		
		// <td class={orgClass} style="font-weight:bold;">{org}</td>
		let tmpOrgTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpOrgTD.className = orgClass;
		tmpOrgTD.setAttribute('style', 'font-weight:bold;');
		tmpOrgTD.textContent = org;
		trItem.appendChild(tmpOrgTD);
		
		//<td class={reqClass}>{reqAtts}</td>
		let tmpReqAttsTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpReqAttsTD.className = reqClass;
		tmpReqAttsTD.textContent = reqAtts;
		trItem.appendChild(tmpReqAttsTD);
		
		// <td class={optClass}>{optAtts}</td>
		let tmpOptAttsTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpOptAttsTD.className = optClass;
		tmpOptAttsTD.textContent = optAtts;
		trItem.appendChild(tmpOptAttsTD);
		
		// <td class={fyiClass}>{fyiAtts}</td>
		let tmpFyiAttsTD = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		tmpFyiAttsTD.className = fyiClass;
		tmpFyiAttsTD.textContent = fyiAtts;
		trItem.appendChild(tmpFyiAttsTD);
		
		mainTd.appendChild(trItem);
		
		if (printCalColor) {
			// mainTd.appendChild(<div style='margin-top: 2px'></div>);
			let tmpDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
			tmpDiv.setAttribute('style', 'margin-top: 2px');
			mainTd.appendChild(tmpDiv);
		}
    }
	
	//Components.utils.reportError('Nb of Event: '+nofEvents);
	
    if (nofEvents) {
		return mainTd;
	} else {
		return;
	}
	},

  createMonthTable : function FGlistPrint_doOtherMonth(document, aMonth) {
    let weekStart = Services.prefs.getIntPref("calendar.week.start", 0);

    let monthName = cal.calGetString("dateFormat", "month." + (aMonth.month +1)+ ".name") + " " + aMonth.year;

    let fsize = Services.prefs.getIntPref("fgprinters.list.fontsizeom", 10);
    let tStyle = 'font-size: ' + fsize + 'px;';

    //let monthTable = <table width='100%' rules='both' style={tStyle}><tr><td colspan='7' align='center'>{monthName}</td></tr></table>;
    let monthTable = document.createElementNS("http://www.w3.org/1999/xhtml","table");
	monthTable.setAttribute('width', '100%');
	monthTable.setAttribute('rules', 'both');
	monthTable.setAttribute('style', tStyle);
	
	let tmpTr = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
	monthTable.appendChild(tmpTr);
	
	let tmpTd = document.createElementNS("http://www.w3.org/1999/xhtml","td");
	tmpTd.setAttribute('colspan', '7');
	tmpTd.setAttribute('align', 'center');
	tmpTd.textContent = monthName;
	tmpTr.appendChild(tmpTd);
	
	
	let firstDate = aMonth.startOfMonth.startOfWeek.clone();
    firstDate.day += weekStart;
    try {
        firstDate.normalize();
    } catch(ex) {
    }
    if (aMonth.startOfMonth.weekday < weekStart) {
        // Go back one week to make sure we display this day
        firstDate.day -= 7;
        try {
            firstDate.normalize();
        } catch(ex) {
        }
    }

    let lastDate = aMonth.endOfMonth.endOfWeek.clone();
    if (aMonth.endOfMonth.weekday < weekStart) {
        // Go back one week so we don't display any extra days
        lastDate.day -= 7;
        try {
            lastDate.normalize();
        } catch(ex) {
        }
    }
    firstDate.isDate = true;
    lastDate.isDate = true;

    let printWeekDays = Services.prefs.getBoolPref("fgprinters.printweekdaysmm", false);
    if (printWeekDays) {
        const weekPrefix = "calendar.week.";
        let prefNames = ["d0sundaysoff", "d1mondaysoff", "d2tuesdaysoff",
                         "d3wednesdaysoff", "d4thursdaysoff", "d5fridaysoff", "d6saturdaysoff"];
        let defaults = [true, false, false, false, false, false, true];
        let daysOff = new Array();
        for (let i of prefNames) {
            if (Services.prefs.getCharPref(weekPrefix+prefNames[i], defaults[i])) {
                daysOff.push(Number(i));
            }
        }
        //let weekRow = <tr/>;
		let weekRow = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
        for (let i = 0; i < 7; i++) {
            let myClass = 'day-box';
            let style = 'padding-left: 0.2em; padding-right: 0.2em; ';
            let dayName = cal.calGetString("dateFormat", "day."+ (((i + weekStart) % 7)+1) + ".Mmm")[0];
            //let day = <td align='center' valign='center' class={myClass}><div style={style}>{dayName}</div></td>
			let day = document.createElementNS("http://www.w3.org/1999/xhtml","td");
			day.setAttribute('align', 'center');
			day.setAttribute('valign', 'center');
			day.className = myClass;
			
			let tmpDayNameDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
			tmpDayNameDiv.setAttribute('style', style);
			tmpDayNameDiv.textContent = dayName;
			day.appendChild(tmpDayNameDiv);
			
            weekRow.appendChild(day);
            try {
                date.normalize();
            } catch(ex) {
            }
        }
        monthTable.appendChild(weekRow);
    }
    
    let date = firstDate.clone();
    let itemListIndex = 0;
    while (date.compare(lastDate) != 1) {
        monthTable.appendChild(this.makeOtherMonthWeek(document, date, aMonth.month));
    }
    return monthTable;
	},

   makeOtherMonthWeek : function FGmakeOtherMonthWeek(document, date, targetMonth) {
    // let weekRow = <tr/>;
	let weekRow = document.createElementNS("http://www.w3.org/1999/xhtml","tr");
	
    let printOMDays = Services.prefs.getBoolPref("fgprinters.printomdaysmm", true);
    const weekPrefix = "calendar.week.";
    let prefNames = ["d0sundaysoff", "d1mondaysoff", "d2tuesdaysoff",
                     "d3wednesdaysoff", "d4thursdaysoff", "d5fridaysoff", "d6saturdaysoff"];
    let defaults = [true, false, false, false, false, false, true];
    let daysOff = new Array();
    for (let i of prefNames) {
        if (Services.prefs.getCharPref(weekPrefix+prefNames[i], defaults[i])) {
            daysOff.push(Number(i));
        }
    }

    for (let i = 0; i < 7; i++) {
        let myClass = 'day-box';
        let style = 'padding-left: 0.2em; padding-right: 0.2em;';
        if (date.month != targetMonth) {
            myClass += ' out-of-month';
            if (!printOMDays) {
                style += 'color: transparent; ';
            }
        } else if (daysOff.some(function(a) { return a == date.weekday; })) {
            myClass += ' day-off';
        }
        
		//let day = <td align='right' valign='center' class={myClass}><div style={style}>{date.day}</div></td>
		let day = document.createElementNS("http://www.w3.org/1999/xhtml","td");
		day.setAttribute('align', 'right');
		day.setAttribute('valign', 'center');
		day.className = myClass;
		let tmpDateDayDiv = document.createElementNS("http://www.w3.org/1999/xhtml","div");
		tmpDateDayDiv.setAttribute('style', style);
		tmpDateDayDiv.textContent = date.day;
		day.appendChild(tmpDateDayDiv);
		
		
        weekRow.appendChild(day);
        date.day++;
        try {
            date.normalize();
        } catch(ex) {
        }
    }
    return weekRow;
	},
	
	setupStyleSheet: function FGlist_setupStyleSheet(html) {
		let fsizeglobaltitle = Services.prefs.getIntPref("fgprinters.fontsizetitle", 26);
		let fsizesubtitle = Services.prefs.getIntPref("fgprinters.fontsizesubtitle", 20);
		let fsizeday = Services.prefs.getIntPref("fgprinters.list.fontsizedayname", 20);
		let dnbk = Services.prefs.getCharPref("fgprinters.headcolour", "#f0f0f0");
		let oomc = Services.prefs.getCharPref("fgprinters.othermonthcolour", "#EEEEFF");
		let wec = Services.prefs.getCharPref("fgprinters.weekendcolour", "#FFFFEE");
		let sansserif = Services.prefs.getBoolPref("fgprinters.sansserif", true);
		let fsizeh = Services.prefs.getIntPref("fgprinters.list.fontsizeheader", 14);
    
		let style = ".main-title { font-size: "+fsizeglobaltitle+"px; font-weight:bold; text-align: center; }\n";
		style += ".sub-title { font-size: "+fsizesubtitle+"px; font-weight:bold; text-align: center; }\n";
		style += ".day-name { border: 1px solid #000; background-color: "+dnbk+"; font-size: "+fsizeday+"px; font-weight: bold; }\n";
		style += ".day-box { border: 1px solid black; vertical-align: top; }\n";
		style += ".day-off { background-color: "+wec+" !important; }\n";
		style += ".out-of-month { background-color: "+oomc+" !important; }\n";
		if (sansserif) { 
			style += "body, tr, td, table, p { font-family: Arial, sans-serif; }\n"; 
		}
		style += ".weekend { background-color: "+wec+"; }\n";
		style += ".normal { }\n";
		style += "td.bordered { border:solid 1px black; border-right:solid 1px black;}\n";
		style += ".header { text-align:center;}\n";	
		
		html.getElementsByTagName('style')[0].textContent += "\n" + style;
	}
};

function isEvent(aObject) {
    return aObject instanceof Components.interfaces.calIEvent;
}