/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

//Components.utils.import("resource://fgprinters/modules/calUtils.jsm");
Components.utils.import("resource://calendar/modules/calUtils.jsm");
 
/** Helper functions for manipulating HTML */


this.EXPORTED_SYMBOLS = ["cal"];
cal.html = {} || cal.html;

/**
 * Create a HTML element
 
 *
 * @param aNode     The context node to search from
 * @param aExpr     The XPath expression to search for
 * @param aResolver (optional) The namespace resolver to use for the expression
 * @param aType     (optional) Force a result type, must be an XPathResult constant
 * @return          The result, see above for details.
 */
cal.html.createElement = function createElement(doc, tag, className, attributes) {
	let elt = doc.createElementNS("http://www.w3.org/1999/xhtml",tag);
	
	if(typeof(className) != 'undefined') elt.className = className;
	
	for (let k of attributes) {
		elt.setAttribute(k, attributes[k]);
	}
	return elt;
}
    