var parentElements = [
  "autoDetach",
  "autoDetachTaggedOnly"
];

// onLoad listener to build the UI and Preview
document.addEventListener('DOMContentLoaded', () => {
  console.debug("AEC: DOMContentLoaded, restoreAllOptions()");
  fillAutoDetachTagSelectOptions()
  .then(() => { restoreAllOptions(); })
  .then(() => { setDisabledAttribute(parentElements); });
});

// onChange listener for all options to save the changed options
OptionsList.forEach((option) => {
  console.debug("AEC: option: " + option);
  /*
  if (option == "borderMode") {
    document.getElementById("bordermode0").addEventListener("change", (e) => {
      console.debug("AEC: Option borderMode-0 changed, saveOptions()");
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
    document.getElementById("bordermode1").addEventListener("change", (e) => {
      console.debug("AEC: Option borderMode-1 changed, saveOptions()");
      saveOptions(e)
      .then(() => { updatePreview(); });
    });
  } else {
  */
    document.getElementById(option).addEventListener("change", (e) => {
      console.debug("AEC: Other Option changed, saveOptions()");
      saveOptions(e)
      //  .then(() => { updatePreview(); })
      ;
    });
  //  }
});

// reset click listener
document.getElementById("reset").addEventListener("click", () => {
  console.debug("AEC: Reset clicked, resetAllOptions()");
  resetAllOptions()
  //  .then(() => { waitAndUpdatePreview(); })
  ;
});

// check Thin versus Double borders listener
/*
document.getElementById("borderWidth").addEventListener("change", (e) => {
  checkThinDouble();
});
document.getElementById("borderStyle").addEventListener("change", (e) => {
  checkThinDouble();
});
*/

// onChange listeners to invoke setAttributeDisabled for nested options
parentElements.forEach((parentElement) => {
  console.debug("AEC: parentElement: " + parentElement);
  document.getElementById(parentElement).addEventListener("change", (e) => {
    setDisabledAttribute([parentElement]);
  });
});
