function setDisabledAttribute(parentElements) {
  parentElements.forEach((parentElement) => {
    console.debug("AEC: parentElement: " + parentElement);
  
    switch (parentElement) {
      case "autoDetach":
        var type = "checkbox";
        var nestedElements = [
          "autoDetachTaggedOnly",
          "autoDetachTriggerTag",
        ];
        break;
      case "autoDetachTaggedOnly":
        var type = "checkbox";
        var nestedElements = [
          "autoDetachTriggerTag",
        ];
        break;
      default:
        return;
    }

    nestedElements.forEach((element) => {
      console.debug("AEC: element: " + element);
      if (type == "radio") {
        if ( element == "bordermode1" || "bordermode0" ) {
          if (document.querySelector('input[name=borderMode]:checked').value == 1) {
            document.getElementById(element).removeAttribute("disabled");
          } else {
            document.getElementById(element).setAttribute("disabled", "true");
          }
        }
      } else if (type == "checkbox") {
        if (document.getElementById(parentElement).checked) {
          console.debug("AEC: enable element: " + element);
          document.getElementById(element).removeAttribute("disabled");
        } else {
          console.debug("AEC: disable element: " + element);
          document.getElementById(element).setAttribute("disabled", "true");
        }
      }
    });
  });
}

async function fillAutoDetachTagSelectOptions() {
  let tagList = await browser.messages.listTags();
  let select = document.getElementById("autoDetachTriggerTag");

  for (let i = 0; i < tagList.length; i++){
    var opt = document.createElement("option");
    opt.value = tagList[i].key;
    opt.innerHTML = tagList[i].tag;
    select.appendChild(opt);
  }
}
