// Add eventListener for onClicked on ALL menu entries
// The different elements must be differed by elements ID in the called function
browser.menus.onClicked.addListener(onContextMenuClicked);
async function onContextMenuClicked(info, tab) {
  if(options.debug)
    console.debug("AEC: Menu ID clicked = " + info.menuItemId);

  if (info.menuItemId != "aec_extractToBrowse")
    return;

  // Load the list of selected messages in message/thread pane
  //
  // The following code line would exclusively return prior (per left click) 
  // selected messages. Opening the context menu on an other message 
  // would NOT return this message for the operations.
  //
  // messages = await browser.mailTabs.getSelectedMessages(tab.id);
  //
  // This following used code line does return the expected message(s) for 
  // the operations.
  //
  messages = await info.selectedMessages;

  collectMessagesToDetach(folder=[], messages, false);
}

// Add eventListener for onClicked on the toolbar button
browser.browserAction.onClicked.addListener(onToolbarButtonClicked);
async function onToolbarButtonClicked(tab, info) {
  if(options.debug) {
    console.debug("AEC: Toolbar button clicked");
    console.debug("AEC: tab.id = " + tab.id);
    console.debug("AEC: info.modifiers = " + info.modifiers);
  }

  if (tab.id == 1) {
    // Load the list of selected messages in message/thread pane
    messages = await browser.mailTabs.getSelectedMessages(tab.id);
  }
  else {
    // Get the displayed message; because of being only one message,
    // we need to create an message.message object to be consistent for later processing
    messages = { messages: await browser.messageDisplay.getDisplayedMessages(tab.id) };
  }

  if(options.debug) {
    console.debug("AEC: messages = " + messages);
    if (messages.messages)
      console.debug("AEC: message count = " + messages.messages.length);
    else if (messages.length) {
      console.debug("AEC: message count = " + messages.length);
    }
  }

  collectMessagesToDetach(folder=[], messages, false);
}

// Add eventListener for onClicked on the header button
browser.messageDisplayAction.onClicked.addListener(onHeaderButtonClicked);
async function onHeaderButtonClicked(tab, info) {
  if(options.debug) {
    console.debug("AEC: Header button clicked");
    console.debug("AEC: tab.id = " + tab.id);
    console.debug("AEC: info.modifiers = " + info.modifiers);
  }

  // Get the displayed message; because of being only one message,
  // we need to create an message.message object to be consistent for later processing
  messages = { messages: await browser.messageDisplay.getDisplayedMessages(tab.id) };

  if(options.debug) {
    console.debug("AEC: messages = " + messages);
    console.debug("AEC: message count = " + messages.length);
  }

  collectMessagesToDetach(folder=[], messages, false);
}

// Add eventListener for onNewMailReceived for automatic detach option
messenger.messages.onNewMailReceived.addListener(async (folder, messages) => {
  if(options.debug)
    console.debug("AEC: onNewMailReceived is fired: ", folder, messages);

  // If AutoDetach is disabled, return
  if (!options.autoDetach)
    return;

  if(options.debug)
    console.debug("AEC: options.autoDetach is enabled");

  // check for account type and return (do nothing), if it is a rss or news account
  let account = await messenger.accounts.get(folder.accountId);
  if(options.debug)
    console.debug("AEC: account type = " + account.type);
  if (account.type == "news" || account.type == "rss")
    return;

  if(options.debug)
    console.debug("AEC: Folder type = " + folder.type);

  // Do not automatically detach from new messages in the following special folders
  if ((folder.type == "drafts") || 
      (folder.type == "template") || 
      (folder.type == "sent") || 
      (folder.type == "junk") || 
      (folder.type == "trash")) {
    if(options.debug)
      console.debug("AEC: Do not automatically detach from new messages in the special folders: drafts, template, sent, junk and trash: " + folder.type);
    return;
  }

  if(options.debug) {
    for (const message of messages.messages) {
      console.debug("AEC: message.id: " + message.id + "\n" + 
                    "AEC: folder: " + folder.name + "\n" +
                    "AEC: subject: " + message.subject + "\n" +
                    "AEC: tags: " + message.tags);
    }
  }


  collectMessagesToDetach(folder, messages, true);
});

async function collectMessagesToDetach(folder, messages, autoDetach) {
  var allMessages = [];
  // Helper inline function for getting attachment details from a message
  const createMessage = async function(message) {
    const attachments = await browser.messages.listAttachments(message.id);
    return {
      id: message.id,
      account: message.folder.accountId,
      folder: message.folder.path,
      attachments: attachments
    };
  }
  // Iterate through all messages
  for(let m of messages.messages) {
    if(options.debug)
      console.debug("AEC: while-loop: message.id: " + m.id + "\n" + 
                    "AEC: while-loop: folder: " + folder.name + "\n" + 
                    "AEC: while-loop: subject: " + m.subject + "\n" +
                    "AEC: while-loop: tags: " + m.tags);

    if ((!options.autoDetachTaggedOnly) || (!autoDetach)) {
      if(options.debug)
        console.debug("AEC: for-loop: Manual process or _No_ trigger tag is necessary");
      allMessages.push(await createMessage(m));
      continue;
    } else {
      // A trigger tag is necessary, check every msg for this tag
      if(options.debug)
        console.debug("AEC: for-loop: The trigger tag '" + options.autoDetachTriggerTag + "' is necessary");
      // Check for the trigger tag and check junk status == false
      if ((m.tags.includes(options.autoDetachTriggerTag)) && (m.junk == false)) {
        if(options.debug)
          console.debug("AEC: for-loop: the necessary tag is included");
        allMessages.push(await createMessage(m));
      }
    }
  }
  while (messages.id) {
    for(let m of messages.messages) {
      if(options.debug)
        console.debug("AEC: while-loop: message.id: " + m.id + "\n" + 
                      "AEC: while-loop: folder: " + folder.name + "\n" + 
                      "AEC: while-loop: subject: " + m.subject + "\n" +
                      "AEC: while-loop: tags: " + m.tags);

      if ((!options.autoDetachTaggedOnly) || (!autoDetach)) {
        if(options.debug)
          console.debug("AEC: while-loop: Manual process or _No_ trigger tag is necessary");
        allMessages.push(await createMessage(m));
        continue;
      } else {
        // A trigger tag is necessary, check every msg for this tag
        if(options.debug)
          console.debug("AEC: while-loop: The trigger tag '" + options.autoDetachTriggerTag + "' is necessary");
        // Check for the trigger tag and check junk status == false
        if ((m.tags.includes(options.autoDetachTriggerTag)) && (m.junk == false)) {
          if(options.debug)
            console.debug("AEC: while-loop: the necessary tag is included");
          allMessages.push(await createMessage(m));
        }
      }
  
    }
  }

  // Call Experiment API to detach attachments from selected messages
  if(options.debug)
    console.debug("AEC: allMessages[].length: " + allMessages.length );
  if (allMessages.length > 0)
    await browser.attachmentExtractorContinuedApi.detachAttachmentsFromSelectedMessages(allMessages);
}
