const prefsUsedInOptionsToListenFor = [
  "mailnews.display.prefer_plaintext",
  "mailnews.display.html_as",
  "mailnews.display.disallow_mime_handlers",
  "mailnews.message_display.disable_remote_image",
  "mail.inline_attachments"
];

// onLoad listener to load Options and LegacyPrefs
document.addEventListener('DOMContentLoaded', async () => {
  consoleDebug("AHT: DOMContentLoaded, restoreAllOptions() and initLegacyPrefs()");
  restoreAllOptions();
  initLegacyPrefs();

  // Listen for prefs changes per LegacyPrefs API
  await messenger.LegacyPrefs.onChanged.addListener(async (name, value) => {
    prefUsedInOptionsChanged("mailnews."+name, value);
  }, "mailnews.");
  await messenger.LegacyPrefs.onChanged.addListener(async (name, value) => {
    prefUsedInOptionsChanged("mail."+name, value);
  }, "mail.");

/*
  document.addEventListener("visibilitychange", async () => {
    consoleDebug("AHT: DOMContent beforeunload");
    await messenger.LegacyPrefs.onChanged.removeListener(async () => {
      prefUsedInOptionsChanged("mailnews."+name, value);
    }, "mailnews.");
    await messenger.LegacyPrefs.onChanged.removeListener(async () => {
      prefUsedInOptionsChanged("mail."+name, value);
    }, "mail.");
  });
*/
  
  async function prefUsedInOptionsChanged(aName, aValue) {
    if(prefsUsedInOptionsToListenFor.includes(aName)) {
      consoleDebug("AHT: prefUsedInOptionsChanged(): LegacyPref prefChanged aName: " + aName);
      consoleDebug("AHT: prefUsedInOptionsChanged(): LegacyPref prefChanged aValue: " + aValue);
      initLegacyPrefs();
    }
  }
});

// onChange listener for all options to save the changed options
OptionsList.forEach((option) => {
  consoleDebug("AHT: OptionsList.forEach(): option: " + option);
  switch(option) {
    case "buttonHtmlMode":
      document.getElementById("buttonMode_html").addEventListener("change", (e) => {
        consoleDebug("AHT: OptionsList.forEach():  Option buttonHtmlMode changed, saveOptions()");
        saveOptions(e);
      });
      document.getElementById("buttonMode_sanitized").addEventListener("change", (e) => {
        consoleDebug("AHT: OptionsList.forEach():  Option buttonHtmlMode changed, saveOptions()");
        saveOptions(e);
      });
      document.getElementById("buttonMode_plaintext").addEventListener("change", (e) => {
        consoleDebug("AHT: OptionsList.forEach():  Option buttonHtmlMode changed, saveOptions()");
        saveOptions(e);
      });
      break;

    default:
      document.getElementById(option).addEventListener("change", (e) => {
        consoleDebug("AHT: OptionsList.forEach():  Option " + option + " changed, saveOptions()");
        saveOptions(e);
        // .then(() => { enableOrDisableOptionUiElements(); });
      });
  }
});

// onChange listener for all options to save the changed prefs
PrefsList.forEach((option) => {
  consoleDebug("AHT: pref: " + option);
  switch(option) {
    case "appHtmlMode":
      document.getElementById("appMode_html").addEventListener("change", (e) => {
        consoleDebug("AHT: PrefsList.forEach():  Option appHtmlMode (original HTML) changed, LegacyPrefs.setPrefsMsgBodyAllowHTML()");
        setPrefsMsgBodyAllowHTML();
      });
      document.getElementById("appMode_sanitized").addEventListener("change", (e) => {
        consoleDebug("AHT: PrefsList.forEach():  Option appHtmlMode (sanitized HTML) changed, LegacyPrefs.setPrefsMsgBodySanitized()");
        setPrefsMsgBodySanitized();
      });
      document.getElementById("appMode_plaintext").addEventListener("change", (e) => {
        consoleDebug("AHT: PrefsList.forEach():  Option appHtmlMode (plaintext) changed, LegacyPrefs.setPrefsMsgBodyAsPlaintext()");
        setPrefsMsgBodyAsPlaintext();
      });
      document.getElementById("appMode_allBodyParts").addEventListener("change", (e) => {
        consoleDebug("AHT: PrefsList.forEach():  Option appHtmlMode (AllBodyParts) changed, LegacyPrefs.setPrefsMsgBodyAllParts()");
        setPrefsMsgBodyAllParts();
      });
      break;

    case "appRemoteContent":
      document.getElementById("appRemoteContent").addEventListener("change", (e) => {
        consoleDebug("AHT: PrefsList.forEach():  Option appRemoteContent changed, LegacyPrefs.setPrefsAppRemoteContent()");
        setPrefsAppRemoteContent();
      });
      break;

    case "allwaysInline":
      document.getElementById("allwaysInline").addEventListener("change", (e) => {
        consoleDebug("AHT: PrefsList.forEach():  Option allwaysInline changed, LegacyPrefs.setPrefsAppAttachmentsInline()");
        setPrefsAppAttachmentsInline();
      });
      break;
  }
});

// reset click listener
document.getElementById("reset").addEventListener("click", () => {
  consoleDebug("AHT: Reset clicked, resetAllOptions()");
  resetAllOptions();
});
