// the user preference,
// if HTML is not allowed. I assume, that the user could have set this to a
// value > 1 in his prefs.js or user.js, but that the value will not change during
// runtime other than through the MsgBody*() functions in Thunderbird or by this add-on functions below.
var gDisallow_classes_no_html = 1;

function saveOptions(e) {
  e.preventDefault();

  return messenger.storage.local.set({
    debug: document.getElementById("debug").checked,
    buttonHtmlMode: document.querySelector('input[name=buttonHtmlMode]:checked').value,
    tempRemoteContent: document.getElementById("tempRemoteContent").checked,
    tempInline: document.getElementById("tempInline").checked,
    commandKey: document.getElementById("commandKey").value
  });
}

function restoreOption(id) {
  return messenger.storage.local.get(id).then((res) => {
    consoleDebug("AHT: restoreOption(id): option.id = " + id);
    let element="";
    switch(id) {
      case "commandKey":
        element = document.getElementById(id);
        element.value = res[id] || DefaultOptions[id];
        break;
      case "buttonHtmlMode":
        // radio handling
        element = document.getElementById(res[id] || DefaultOptions[id]);
        element.checked = true;
        break;
      default:
        // checkbox handling
        element = document.getElementById(id);
        if (element.type && element.type == "checkbox") {
          consoleDebug( "AHT: restoreOption(id): " + element.id + " = " + res[id] );
          if (res[id] === undefined) {
            element.checked = DefaultOptions[id];
          } else {
            element.checked = res[id];
          }
        } else {
          consoleDebug( "AHT: restoreOption(id): " + element.id + " = " + res[id] );
          element.value = res[id] || DefaultOptions[id];
        }
    }
  }, defaultError);
}

async function restoreAllOptions() {
  await restoreOption("debug");
  await restoreOption("buttonHtmlMode");
  await restoreOption("tempRemoteContent");
  await restoreOption("tempInline");
  await restoreOption("commandKey");
}

async function resetToDefault() {
  // Reset LegacyPrefs
  await setPrefsMsgBodyAllowHTML();
  await messenger.LegacyPrefs.setPref("mailnews.message_display.disable_remote_image", true);
  await messenger.LegacyPrefs.setPref("mail.inline_attachments", true);
  await initLegacyPrefs();

  // Reset localstorage options
  return messenger.storage.local.remove(OptionsList).then(() => {
    restoreAllOptions();
  });
}

async function resetToRecommended() {
  // Reset LegacyPrefs
  await setPrefsMsgBodySanitized();
  await messenger.LegacyPrefs.setPref("mailnews.message_display.disable_remote_image", true);
  await messenger.LegacyPrefs.setPref("mail.inline_attachments", false);
  await initLegacyPrefs();

  // Reset localstorage options
  return messenger.storage.local.remove(OptionsList).then(() => {
    restoreAllOptions();
  });
}

////// Handle Legacy Prefs by the Experiment API "Legacy Prefs" /////////////////////////////////
async function initLegacyPrefs() {
  consoleDebug("AHT: function initLegacyPrefs()");

  let prefer_plaintext = await messenger.LegacyPrefs.getPref("mailnews.display.prefer_plaintext");
  let html_as = await messenger.LegacyPrefs.getPref("mailnews.display.html_as");
  let disallow_classes = await messenger.LegacyPrefs.getPref("mailnews.display.disallow_mime_handlers");
  
  if (disallow_classes > 0)
  gDisallow_classes_no_html = disallow_classes;
  // else gDisallow_classes_no_html keeps its inital value
  
  let AllowHTML_menuitem = document.getElementById("appMode_html");
  let Sanitized_menuitem = document.getElementById("appMode_sanitized");
  let AsPlaintext_menuitem = document.getElementById("appMode_plaintext");
  let AllBodyParts_menuitem = document.getElementById("appMode_allBodyParts");
  
  let appMode_allBodyPartsEnabled = await messenger.LegacyPrefs.getPref("mailnews.display.show_all_body_parts_menu");
  consoleDebug("AHT: initLegacyPrefs: mailnews.display.show_all_body_parts_menu = " + appMode_allBodyPartsEnabled);

  let element = document.getElementById("allBodyParts");
  if(appMode_allBodyPartsEnabled) {
    if (element.classList.contains("hidden")) {
      element.classList.remove("hidden");
      consoleDebug("AHT: initLegacyPrefs: element.classList.remove");
    }
  } else {
    if (!element.classList.contains("hidden")) {
      element.classList.add("hidden");
      consoleDebug("AHT: initLegacyPrefs: element.classList.add");
    }
  }

  consoleDebug("AHT: initLegacyPrefs: set the correct radio item as checked.");
  consoleDebug("AHT: initLegacyPrefs: " + prefer_plaintext + " " + html_as + " " + disallow_classes);  

  if ((prefer_plaintext != true) && (html_as == 0) && (disallow_classes == 0) && AllowHTML_menuitem)
    AllowHTML_menuitem.checked = true;
  else if ((prefer_plaintext != true) && (html_as == 3) && (disallow_classes > 0) && Sanitized_menuitem)
    Sanitized_menuitem.checked = true;
  else if ((prefer_plaintext == true) && (html_as == 1) && (disallow_classes > 0) && AsPlaintext_menuitem)
    AsPlaintext_menuitem.checked = true;
  else if ((prefer_plaintext != true) && (html_as == 4) && (disallow_classes == 0) && AllBodyParts_menuitem)
    AllBodyParts_menuitem.checked = true;
  
  document.getElementById("appRemoteContent").checked = !(await messenger.LegacyPrefs.getPref("mailnews.message_display.disable_remote_image"));
  document.getElementById("allwaysInline").checked = await messenger.LegacyPrefs.getPref("mail.inline_attachments");

  enableOrDisableOptionUiElements();
}

async function setPrefsMsgBodyAllowHTML() {
  consoleDebug("AHT: function setPrefsMsgBodyAllowHTML()");
  await messenger.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", false);
  await messenger.LegacyPrefs.setPref("mailnews.display.html_as", 0);
  await messenger.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers", 0);
}

async function setPrefsMsgBodySanitized() {
  consoleDebug("AHT: function setPrefsMsgBodySanitized()");
  let disallow_classes = await messenger.LegacyPrefs.getPref("mailnews.display.disallow_mime_handlers");
  if (disallow_classes > 0)
    gDisallow_classes_no_html = disallow_classes;
  // else gDisallow_classes_no_html keeps its inital value

  await messenger.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", false);
  await messenger.LegacyPrefs.setPref("mailnews.display.html_as", 3);
  await messenger.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers", gDisallow_classes_no_html);
}

async function setPrefsMsgBodyAsPlaintext() {
  consoleDebug("AHT: function setPrefsMsgBodyAsPlaintext()");
  let disallow_classes = await messenger.LegacyPrefs.getPref("mailnews.display.disallow_mime_handlers");
  if (disallow_classes > 0)
    gDisallow_classes_no_html = disallow_classes;
  // else gDisallow_classes_no_html keeps its inital value

  await messenger.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", true);
  await messenger.LegacyPrefs.setPref("mailnews.display.html_as", 1);
  await messenger.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers", gDisallow_classes_no_html);
}

async function setPrefsMsgBodyAllParts() {
  consoleDebug("AHT: function setPrefsMsgBodyAllParts()");
  await messenger.LegacyPrefs.setPref("mailnews.display.prefer_plaintext", false);
  await messenger.LegacyPrefs.setPref("mailnews.display.html_as", 4);
  await messenger.LegacyPrefs.setPref("mailnews.display.disallow_mime_handlers", 0);
}

async function setPrefsAppRemoteContent() {
  consoleDebug("AHT: function setPrefsAppRemoteContent()");
  await messenger.LegacyPrefs.setPref("mailnews.message_display.disable_remote_image", !(document.getElementById("appRemoteContent").checked));
  enableOrDisableOptionUiElements();
}

async function setPrefsAppAttachmentsInline() {
  consoleDebug("AHT: function setPrefsAppAttachmentsInline()");
  await messenger.LegacyPrefs.setPref("mail.inline_attachments", document.getElementById("allwaysInline").checked);
  enableOrDisableOptionUiElements();
}
