function resetToDefault() {
  // This returns a Promise, so we do not have to define this function as
  // async and have to await the call before returning.
  return messenger.messageContentPolicy.update({ msgBodyAs: "plaintext" });
}

(async () => {
  // Enforce default. Since all open tabs are still connected to the preference
  // observer, they will all be updated to honour the default.
  await resetToDefault();

  // Add eventListener for onClicked on the message header button (we could also
  // use the menu typed action button here and allow the user to pick one of the 
  // 3 view options for this tab.)
  messenger.messageDisplayAction.onClicked.addListener(async (tab, info) => {
    await messenger.allowHtmlTemp.reconnectTab(tab.id);
    await messenger.messageContentPolicy.update({ msgBodyAs: "original" });
    // The reload will disconnect the tab from the preference observer again.
  });

  // Disconnect all message tabs from the menu/prefs.
  messenger.messageDisplay.onMessageDisplayed.addListener(async (tab, message) => {
    await messenger.allowHtmlTemp.disconnectTab(tab.id);
    // We may have allowed a tab to show html and reloaded it (automatically), so
    // the pref may still be set to "original" -> reset to default.
    await resetToDefault();

    let hasHtmlMimePart = await messenger.allowHtmlTemp.checkMailForHtmlpart(message.id, false);
    if(hasHtmlMimePart) {
      messenger.messageDisplayAction.enable(tab.id);
    } else {
      messenger.messageDisplayAction.disable(tab.id);
    }
  });
  
  // Disconnect all already open tabs.
  let tabs = await messenger.tabs.query({});
  for (let tab of tabs) {
    if (!["messageDisplay", "mail"].includes(tab.type)) {
      continue;
    }
    await messenger.allowHtmlTemp.disconnectTab(tab.id);
  }

})();

