// Since we disconnect all tabs from the policy prefs, we need to manually reload
// them on pref updates. If the pref change is a temporary add-on-inflicted change,
// we reload only a specific tab.
var ahtStatus = {
  reloadAllTabs: true
};

messenger.messageContentPolicy.onChanged.addListener(async (newValue) => {
  console.log(ahtStatus);

  // If this policy change is the second part of an add-on inflicted temporary
  // policy change (returning to default), ignore it and reset the ahtStatus.
  if (ahtStatus.ignorePolicyChange) {
    ahtStatus = {
      reloadAllTabs: true
    }
    return;
  }

  let tabs = await messenger.tabs.query({});
  for (let tab of tabs) {
    if (!["messageDisplay", "mail"].includes(tab.type)) {
      continue;
    }
    if (ahtStatus.reloadAllTabs || ahtStatus.reloadTab == tab.id) {
      console.log("Reload tab:", tab.id);
      await messenger.allowHtmlTemp.reloadTab(tab.id);
    }
  }
  await setButtonIconAndLabel()
});

messenger.storage.onChanged.addListener(optionsInit);

// Add eventListener for onClicked on the message header button.
messenger.messageDisplayAction.onClicked.addListener(async (tab, info) => {
  const modeMap = {
    "buttonMode_plaintext": "plaintext",
    "buttonMode_sanitized": "sanitized",
    "buttonMode_html": "original",
  }
  let buttonPolicy = modeMap[await getOption("buttonHtmlMode")];

  let { msgBodyAs: currentPolicy } = await messenger.messageContentPolicy.getCurrent();
  if (buttonPolicy == currentPolicy) {
    // Nothing for us to do.
    return;
  }

  // The following policy switch is not a change of the default, but a temporary
  // switch, so we have to return to the current policy once the tab is loaded.
  ahtStatus = {
    returnToPolicy: currentPolicy,
    reloadTab: tab.id,
  }
  // The following policy change will trigger a message reload, which will return
  // the contentPolicy to the former value.
  await messenger.messageContentPolicy.update({ msgBodyAs: buttonPolicy });
});

// Disconnect all message tabs from the menu/prefs.
messenger.messageDisplay.onMessageDisplayed.addListener(async (tab, message) => {
  await messenger.allowHtmlTemp.disconnectTab(tab.id);

  // This is a reload caused by an add-on inflicted policy change, return to the
  // user defined value.
  if (ahtStatus.returnToPolicy) {
    // The following policy update should not trigger a reload.
    let msgBodyAs = ahtStatus.returnToPolicy;
    ahtStatus = {
      ignorePolicyChange: true
    }
    await messenger.messageContentPolicy.update({ msgBodyAs });
  }
});


(async () => {
  await optionsMigrate();
  await optionsInit();

  // Disconnect all already open tabs.
  let tabs = await messenger.tabs.query({});
  for (let tab of tabs) {
    if (!["messageDisplay", "mail"].includes(tab.type)) {
      continue;
    }
    await messenger.allowHtmlTemp.disconnectTab(tab.id);
  }

})();

