Components.utils.import("resource:///modules/gloda/mimemsg.js");

window.addEventListener("load", function(e) { ahtButtonStatus.startup(); }, false);
window.addEventListener("unload", function(e) { ahtButtonStatus.shutdown(); }, false);

var ahtButtonStatus = {

	startup: function()
	{
		this.observerService = Components.classes["@mozilla.org/observer-service;1"]
			.getService(Components.interfaces.nsIObserverService);
		this.observerService.addObserver(this, "mail:updateToolbarItems", false);

		this.ahtRefreshButtons();
	},

	shutdown: function()
	{
		this.observerService.removeObserver(this, "mail:updateToolbarItems");
	},

	observe: function(subject, topic, data)
	{
		switch(topic)
		{
			case "mail:updateToolbarItems":
				this.ahtRefreshButtons();
				break;
		}
	},

	ahtRefreshButtons: function()
	{
		// ahtHdrButton doesn't exist in Seamonkey (no hdrButtons supported), 
		// so we have to ask in the lines below with 'if(ahtHdrButton)' to
		// avoid JS errors
		// ahtToolbarButton exists only, if the button is added to the toolbar,
		// wo we have to ask, too
		let ahtHdrButton = document.getElementById("hdrAHTButton");
		let ahtToolbarButton = document.getElementById("AllowHTMLtemp");

		if (ahtToolbarButton) {
			try {
				// get the msg header (to ask for junk status and 'Body: text/html')
				let ahtMsgHdr = gFolderDisplay.selectedMessage;
				// ask for selected messages junk status
				let ahtMsgJunkScore = ahtMsgHdr.getStringProperty("junkscore");
				let ahtMsgIsJunk = (ahtMsgJunkScore == Components.interfaces.nsIJunkMailPlugin.IS_SPAM_SCORE);
	
				// if msg is junk or feed or multiple messages are selected disable the ahtButtons
				if((ahtMsgIsJunk) || (gFolderDisplay.selectedMessageIsFeed) || (gFolderDisplay.selectedCount != 1))
				{
					if(ahtHdrButton){
						ahtHdrButton.setAttribute("disabled", true);
					}
					ahtToolbarButton.setAttribute("disabled", true);
				}
	
				else
				{
					// search for 'Body: text/html' in MIME parts,
					// it seems this is only working if messages are downloaded for offline reading?
					MsgHdrToMimeMessage(ahtMsgHdr, null, function (aMsgHdr, aMimeMsg) {
						// 'Body: text/html' is found, enable ahtButtons
						if(aMimeMsg.prettyString().search("Body: text/html") != -1) {
							if(ahtHdrButton){
								ahtHdrButton.removeAttribute("disabled");
							}
							// we MUST use removeAttribute("disabled")
							// setAttribute to false leads to problems in tabbar-toolbar
							ahtToolbarButton.removeAttribute("disabled");
						}
						// no 'Body: text/html', disable ahtButtons
						else {
							if(ahtHdrButton){
								ahtHdrButton.setAttribute("disabled", true);
							}
							ahtToolbarButton.setAttribute("disabled", true);
						}
					}, true);
				}
			}
			catch(e) {
				// this disables the ahtButtons if the selected folder
				// is changed and no more msg is selected
				if(ahtHdrButton){
					ahtHdrButton.setAttribute("disabled", true);
				}
				if(ahtToolbarButton) {
					ahtToolbarButton.setAttribute("disabled", true);
				}
			}
		}
	}
}
