Components.utils.import("resource:///modules/gloda/mimemsg.js");

window.addEventListener("load", function(e) { ahtButtonSetIcon.startup(); }, false);
window.addEventListener("unload", function(e) { ahtButtonSetIcon.shutdown(); }, false);

window.addEventListener("load", function(e) { ahtButtonStatus.startup(); }, false);
window.addEventListener("unload", function(e) { ahtButtonStatus.shutdown(); }, false);

var ahtButtonSetIcon = {

	startup: function()
	{
		Services.prefs.addObserver("", this, false);

		this.refreshInformation();
	},

	shutdown: function()
	{
		Services.prefs.removeObserver("", this);
	},

	observe: function(subject, topic, data)
	{
		if (topic != "nsPref:changed")
		{
			return;
		}

		switch(data)
		{
			case "extensions.allowhtmltemp.ButtonFunction":
				this.refreshInformation();
				break;
			case "mailnews.message_display.disable_remote_image":
				this.refreshInformation();
				break;
			case "extensions.allowhtmltemp.ForceRemoteContent":
				this.refreshInformation();
				break;
		}
	},

	refreshInformation: function()
	{
		let aht_pref_buttonfunction = Services.prefs.getIntPref("extensions.allowhtmltemp.ButtonFunction");
		let aht_pref_app_remote = Services.prefs.getBoolPref("mailnews.message_display.disable_remote_image");
		let aht_pref_forceremote = Services.prefs.getBoolPref("extensions.allowhtmltemp.ForceRemoteContent");
	
		let ahtToolbarButton = document.getElementById("AllowHTMLtemp");
		let ahtHdrButton = document.getElementById("hdrAHTButton");

		if (ahtToolbarButton) {
			switch (aht_pref_buttonfunction) {
				case 0:
					if (!(aht_pref_app_remote) || (aht_pref_forceremote)) {
						ahtToolbarButton.setAttribute("AHT-htmlStatus", "Plus");
						ahtToolbarButton.setAttribute("label", ahtToolbarButton.getAttribute("labelAHT-htmlStatusPlus"));
					}
					else {
						ahtToolbarButton.setAttribute("AHT-htmlStatus", "Original");
						ahtToolbarButton.setAttribute("label", ahtToolbarButton.getAttribute("labelAHT-htmlStatusOriginal"));
					}
				break;
				case 1:
					ahtToolbarButton.setAttribute("AHT-htmlStatus", "Sanitized");
					ahtToolbarButton.setAttribute("label", ahtToolbarButton.getAttribute("labelAHT-htmlStatusSanitized"));
				break;
				case 2:
					ahtToolbarButton.setAttribute("AHT-htmlStatus", "Plaintext");
					ahtToolbarButton.setAttribute("label", ahtToolbarButton.getAttribute("labelAHT-htmlStatusPlaintext"));
				break;
			}
		}

		if (ahtHdrButton) {
			switch (aht_pref_buttonfunction) {
				case 0:
					if (!(aht_pref_app_remote) || (aht_pref_forceremote)) {
						ahtHdrButton.setAttribute("AHT-htmlStatus", "Plus");
						ahtHdrButton.setAttribute("label", ahtHdrButton.getAttribute("labelAHT-htmlStatusPlus"));
					}
					else {
						ahtHdrButton.setAttribute("AHT-htmlStatus", "Original");
						ahtHdrButton.setAttribute("label", ahtHdrButton.getAttribute("labelAHT-htmlStatusOriginal"));
					}
				break;
				case 1:
					ahtHdrButton.setAttribute("AHT-htmlStatus", "Sanitized");
					ahtHdrButton.setAttribute("label", ahtHdrButton.getAttribute("labelAHT-htmlStatusSanitized"));
				break;
				case 2:
					ahtHdrButton.setAttribute("AHT-htmlStatus", "Plaintext");
					ahtHdrButton.setAttribute("label", ahtHdrButton.getAttribute("labelAHT-htmlStatusPlaintext"));
				break;
			}
		}

	}
}

var ahtButtonStatus = {

	startup: function()
	{
		this.observerService = Components.classes["@mozilla.org/observer-service;1"]
			.getService(Components.interfaces.nsIObserverService);
		this.observerService.addObserver(this, "mail:updateToolbarItems", false);

		this.ahtRefreshButtons();
	},

	shutdown: function()
	{
		this.observerService.removeObserver(this, "mail:updateToolbarItems");
	},

	observe: function(subject, topic, data)
	{
		switch(topic)
		{
			case "mail:updateToolbarItems":
				this.ahtRefreshButtons();
				ahtButtonSetIcon.refreshInformation();
				break;
		}
	},

	ahtRefreshButtons: function()
	{
		// ahtHdrButton doesn't exist in Seamonkey (no hdrButtons supported), 
		// so we have to ask in the lines below with 'if(ahtHdrButton)' to
		// avoid JS errors
		// ahtToolbarButton exists only, if the button is added to the toolbar,
		// wo we have to ask, too
		let ahtHdrButton = document.getElementById("hdrAHTButton");
		let ahtToolbarButton = document.getElementById("AllowHTMLtemp");
		let ahtKey = document.getElementById("ahtButton-key");

		try {
			// get the msg header (to ask for junk status and 'Body: text/html')
			let ahtMsgHdr = gFolderDisplay.selectedMessage;
			// ask for selected messages junk status
			let ahtMsgJunkScore = ahtMsgHdr.getStringProperty("junkscore");
			let ahtMsgIsJunk = (ahtMsgJunkScore == Components.interfaces.nsIJunkMailPlugin.IS_SPAM_SCORE);

			// if msg is junk or feed or multiple messages are selected disable the ahtButtons
			if((ahtMsgIsJunk) || (gFolderDisplay.selectedMessageIsFeed) || (gFolderDisplay.selectedCount != 1))
			{
				if(ahtHdrButton)
					ahtHdrButton.setAttribute("disabled", true);
				if(ahtToolbarButton)
					ahtToolbarButton.setAttribute("disabled", true);
				if(ahtKey)
					ahtKey.setAttribute("disabled", true);
			}

			else
			{
				// search for 'Body: text/html' in MIME parts,
				// it seems this is only working if messages are downloaded for offline reading?
				MsgHdrToMimeMessage(ahtMsgHdr, null, function (aMsgHdr, aMimeMsg) {

					// console.log("AHT ----------------");
					// console.log("Body: text/html" + aMimeMsg.prettyString().search("Body: text/html"));
					// console.log("text/html" + aMimeMsg.prettyString().search("text/html"));
					// console.log("Body: plain/html" + aMimeMsg.prettyString().search("Body: plain/html"));
					// console.log("plain/html" + aMimeMsg.prettyString().search("plain/html"));
					// console.log("multipart/alternative" + aMimeMsg.prettyString().search("multipart/alternative"));
					// console.log("multipart/signed" + aMimeMsg.prettyString().search("multipart/signed"));
					// console.log("multipart/encrypted" + aMimeMsg.prettyString().search("multipart/encrypted"));

					// 'Body: text/html' is found, enable ahtButtons; multipart/encrypted enables the button for encrypted PGP/MIME messages
					if((aMimeMsg.prettyString().search("Body: text/html") != -1) || (aMimeMsg.prettyString().search("multipart/encrypted") != -1)) {
						// we MUST use removeAttribute("disabled")
						// setAttribute to false leads to problems in tabbar-toolbar
						if(ahtHdrButton)
							ahtHdrButton.removeAttribute("disabled");
						if(ahtToolbarButton)
							ahtToolbarButton.removeAttribute("disabled");
						if(ahtKey)
							ahtKey.removeAttribute("disabled");
					}
					// no 'Body: text/html', disable ahtButtons
					else {
						if(ahtHdrButton)
							ahtHdrButton.setAttribute("disabled", true);
						if(ahtToolbarButton)
							ahtToolbarButton.setAttribute("disabled", true);
						if(ahtKey)
							ahtKey.setAttribute("disabled", true);
					}
				}, true, { examineEncryptedParts: true });   // examineEncryptedParts=true is necessary for encrypted S/MIME messages
			}
		}
		catch(e) {
			// this disables the ahtButtons if the selected folder
			// is changed and no more msg is selected
			if(ahtHdrButton)
				ahtHdrButton.setAttribute("disabled", true);
			if(ahtToolbarButton)
				ahtToolbarButton.setAttribute("disabled", true);
			if(ahtKey)
				ahtKey.setAttribute("disabled", true);
		}
	}
}
