Components.utils.import("resource://gre/modules/Services.jsm");

var GetSendButton_functions = {

  /**
    * Get messages for the account selected from Menu dropdowns.
    * if offline, prompt for getting messages.
    *
    * @param aFolder (optional) a folder in the account for which messages should
    *                           be retrieved.  If null, all accounts will be used.
    */
  GetSingleAccountOrGetAndSend: function(aFolder,event)
  {
    if (!aFolder) {
      this.DecideGetAndSendMessages(event);
      return;
    }

    if (MailOfflineMgr.isOnline() || MailOfflineMgr.getNewMail()) {
      var server = aFolder.server;
      GetMessagesForInboxOnServer(server);
    }
  },

  // ----- Funktion des Buttons Get/Send -----
  DecideGetAndSendMessages: function(event)
  {
  	var prefGetSendButtonSend = Services.prefs.getBoolPref("extensions.getsendbutton.GetSendButton_SendYes", true);
  	var prefGetSendButtonOnlySingleAccount = Services.prefs.getBoolPref("extensions.getsendbutton.GetSendButton_OnlySingleAccount", true);
  	var prefGetSendButtonPass = Services.prefs.getBoolPref("extensions.getsendbutton.GetSendButton_AskPasswords", true);

    if (prefGetSendButtonSend) {   // Send=Yes
		  if (!prefGetSendButtonPass)       // Ask not for passwords
			{
        if ((event.shiftKey==true) || (!prefGetSendButtonOnlySingleAccount)) {
          goDoCommand('cmd_getMsgsForAuthAccounts');
				}
        else {
          goDoCommand('cmd_getNewMessages'); // nur aktuelles Konto abrufen
        }
        if (!(event.ctrlKey || event.metaKey)) { // STRG (or Cmd on OS X) disables sending
          goDoCommand('cmd_sendUnsentMsgs');
        }
      }
      else if (prefGetSendButtonPass)  // Ask for passwords
      {
        if ((event.shiftKey==true) || (!prefGetSendButtonOnlySingleAccount)) {
          this.GetMessagesForAllAccounts();
        }
        else {
          goDoCommand('cmd_getNewMessages'); // nur aktuelles Konto abrufen
        }
        if (!(event.ctrlKey || event.metaKey)) { // STRG (or Cmd on OS X) disables sending
          goDoCommand('cmd_sendUnsentMsgs');
        }
      }
    }
    else {    // Send=No
      if (!prefGetSendButtonPass)       // Ask not for passwords
      {
        if ((event.shiftKey==true) || (!prefGetSendButtonOnlySingleAccount)) {
          goDoCommand('cmd_getMsgsForAuthAccounts');
        }
        else {
          goDoCommand('cmd_getNewMessages'); // nur aktuelles Konto abrufen
        }
      }
      else if (prefGetSendButtonPass)  // Ask for passwords
      {
        if ((event.shiftKey==true) || (!prefGetSendButtonOnlySingleAccount)) {
          this.GetMessagesForAllAccounts();
        }
        else {
          goDoCommand('cmd_getNewMessages'); // nur aktuelles Konto abrufen
        }
      }
    }
  },

  GetMessagesForAllAccounts: function()
  {
    //dump("GetSendButton: alle Konten");

    if (MailOfflineMgr.isOnline() || this.PromptGoOnline())
    {
      //dump("GetSendButton: wir sind online");
  
      var allServers = accountManager.allServers;
      // Array of arrays of servers for a particular folder.
      var pop3DownloadServersArray = [];
      // Parallel array of folders to download to...
      var localFoldersToDownloadTo = [];
      var pop3Server;

      for (var i = 0; i < allServers.length; ++i)
      {
        var currentServer = allServers.queryElementAt(i, Components.interfaces.nsIMsgIncomingServer);
        if (currentServer.protocolInfo.canGetMessages)
        {
          //dump("GetSendButton: knnen Mails abholen");
  
          if (currentServer.type == "pop3") // && currentServer.downloadOnBiff) // force mail download 
                                            // (ignore account pref download new mail automatically (downloadOnBiff))
          {
            //dump("GetSendButton: POP3-Konto");
  
            CoalesceGetMsgsForPop3ServersByDestFolder(currentServer,
              pop3DownloadServersArray, localFoldersToDownloadTo);
            pop3Server = currentServer.QueryInterface(Components.interfaces.nsIPop3IncomingServer);
          }
          else
          {
            //dump("GetSendButton: sonstiges Konto");
  
            // Check to see if there are new messages on the server
            currentServer.performBiff(msgWindow);
          }
        }
      }
      for (var i = 0; i < pop3DownloadServersArray.length; ++i)
      {
        //dump("GetSendButton: im pop3array - frage jetzt ab");

        // Any ol' pop3Server will do - the serversArray specifies which servers
        // to download from.
        pop3Server.downloadMailFromServers(pop3DownloadServersArray[i],
                                           pop3DownloadServersArray[i].length,
                                           msgWindow,
                                           localFoldersToDownloadTo[i],
                                           null);
      }
    }
  },

  PromptGoOnline: function()
  {
    //dump("GetSendButton: PromptGoOnline");

    const nsIPS = Components.interfaces.nsIPromptService;
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(nsIPS);
    var alwaysAsk = {value: true};

    var goOnline =  promptService.confirmEx(window,
                                            MailOfflineMgr.offlineBundle.getString('getMessagesOfflineWindowTitle1'),
                                            MailOfflineMgr.offlineBundle.getString('getMessagesOfflineLabel1'),
                                            nsIPS.STD_YES_NO_BUTTONS,
                                            null, null, null,
                                            null, alwaysAsk) == 0 ? true : false;

    if (goOnline)
      MailOfflineMgr.offlineManager.goOnline(false, false, msgWindow);
    return goOnline;
  },

  PromptSendOrNot: function()
  {
    //dump("GetSendButton: PromptSendOrNot");

    const nsIPS = Components.interfaces.nsIPromptService;
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(nsIPS);
    var alwaysAsk = {value: true};

    if (!promptsBundle)
      var promptsBundle = document.getElementById("getsendbuttonPrompts");

    var sendMessages = promptService.confirmEx(window,
                                               promptsBundle.getString('sendMessagesWindowTitle'),
                                               promptsBundle.getString('sendMessagesLabel'),
                                               nsIPS.STD_YES_NO_BUTTONS,
                                               null, null, null,
                                               null, alwaysAsk) == 0 ? true : false;

    return sendMessages;
  },

  PromptGoOnlineToSend: function()
  {
    //dump("GetSendButton: PromptGoOnlineToSend");

    const nsIPS = Components.interfaces.nsIPromptService;
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(nsIPS);
    var alwaysAsk = {value: true};

    if (!promptsBundle)
      var promptsBundle = document.getElementById("getsendbuttonPrompts");

    var goOnline = promptService.confirmEx(window,
                                           promptsBundle.getString('askOnlineWindowTitle'),
                                           promptsBundle.getString('askOnlineLabel'),
                                           nsIPS.STD_YES_NO_BUTTONS,
                                           null, null, null,
                                           null, alwaysAsk) == 0 ? true : false;

    if (goOnline)
      MailOfflineMgr.offlineManager.goOnline(false, false, msgWindow);
    return goOnline;
  },

  SendNow: function()
  {
    Components.classes["@mozilla.org/activity-manager;1"]
              .getService(Components.interfaces.nsIActivityManager)
              .cleanUp();
    openActivityMgr();
    goDoCommand('cmd_sendUnsentMsgs');
  },

  // ----- Hauptfunktion beim ShutDown -----
  SendUnsentBeforeShutDown: function()
  {
    var prefSendUnsentMessages = Services.prefs.getIntPref("extensions.getsendbutton.shutdown_state", 0);
    var prefGoOnline = Services.prefs.getIntPref("extensions.getsendbutton.goonline_state", 0);

    //dump("GetSendButton: SendUnsentBeforeShutDown");
    //dump("GetSendButton: extensions.getsendbutton.shutdown_state: ".prefSendUnsentMessages);
    //dump("GetSendButton: extensions.getsendbutton.goonline_state: ".prefGoOnline);

    if (MailOfflineMgr.haveUnsentMessages())  // if there are unsent messages
    {
      if (MailOfflineMgr.isOnline())   // we are online
      {
        //dump("GetSendButton: Online");

        switch(prefSendUnsentMessages)
        {
          case 2:    // do not send unsent messages, so we can quit now
            break;
          case 1:    // send unsent messages automatically
            this.SendNow();
            break;
          case 0:    // ask, if we should send unsent messages
            break;
        }
      }
      else    //we are offline, so we've to check the related prefs
      {
        //dump("GetSendButton: Offline");

        switch(prefGoOnline)
        {
          case 0:   // ask, if we should go online
            break;
          case 1:   // automatically go online
            if (prefSendUnsentMessages==0)
            {
              if (this.PromptGoOnlineToSend()) {   // ask, if we should go online to send
                this.SendNow();
              }
              break;
            }
            if (prefSendUnsentMessages==1)   // automatically send unsent
            {
              //dump("GetSendButton: Offline, automatisch senden");

              MailOfflineMgr.offlineManager.goOnline(false, false, msgWindow);
              this.SendNow();
              break;
            }
            break;
          case 2:   // do not go online, so we can quit now
            break;
        }
      }
    }
  }
}

var GetSendButton_prefs = {

  setGUI: function(domID, elementValue) {
    document.getElementById(domID).setAttribute("disabled", elementValue);
  },

  getGUI: function(domID) {
    return document.getElementById(domID).getAttribute("selected");
  },

  updateGUI: function() {
    //    this.setGUI("getsendbuttonGetSendButton_AskPasswords", this.getGUI("getsendbuttonGetSendButton_RadioSingle"));
  }

}